/*
 * Decompiled with CFR 0.152.
 */
package org.gvagroup.common;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SharedData {
    public static final String ACARS_POOL = "$acarsPool$data";
    public static final String ACARS_DAEMON = "$acarsDaemon$data";
    public static final String ACARS_CACHEINFO = "$acarsDaemon$cacheInfo";
    public static final String ACARS_CMDSTATS = "$acarsDaemon$cmdStats";
    public static final String JDBC_POOL = "$jdbc$pool";
    public static final String JEDIS_POOL = "$valkey$pool";
    public static final String ECON_DATA = "$econ$master";
    public static final String ELITE_INFO = "$elite$info";
    private static final Logger log = LogManager.getLogger(SharedData.class);
    private static final Collection<String> _appNames = Collections.synchronizedSet(new LinkedHashSet());
    private static final Map<String, Serializable> _data = new ConcurrentHashMap<String, Serializable>();
    private static final Map<String, ClassLoader> _loaders = new ConcurrentHashMap<String, ClassLoader>();

    private SharedData() {
    }

    public static void addApp(String appCode) {
        _appNames.add(appCode);
    }

    public static Collection<String> getApplications() {
        return new LinkedHashSet<String>(_appNames);
    }

    public static void addData(String key, Serializable value) {
        ClassLoader myLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = _loaders.get(key);
        if (cl != null && cl != myLoader) {
            log.warn("Shared data {} already loaded by {}", (Object)key, (Object)cl);
        }
        _data.put(key, value);
        _loaders.put(key, myLoader);
    }

    public static Serializable get(String key) {
        return _data.get(key);
    }

    public static synchronized void purge(String appCode) {
        int objCount = 0;
        ClassLoader myLoader = Thread.currentThread().getContextClassLoader();
        Iterator<Map.Entry<String, ClassLoader>> i = _loaders.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, ClassLoader> me = i.next();
            if (myLoader != me.getValue()) continue;
            if (_data.remove(me.getKey()) == null) {
                log.warn("Unable to remove data for {}", (Object)me.getKey());
            }
            i.remove();
            ++objCount;
        }
        _appNames.remove(appCode);
        log.info("Removed {} shared objects", (Object)objCount);
    }

    public static String getData() {
        return _data.toString();
    }
}

