/*
 * Decompiled with CFR 0.152.
 */
package org.gvagroup.ipc;

import org.gvagroup.ipc.WorkerState;

public class WorkerStatus
implements Comparable<WorkerStatus> {
    private long _execStartTime;
    private long _execStopTime;
    private final String _name;
    private String _msg;
    private WorkerState _status;
    private final int _sortOrder;
    private long _execCount;
    private boolean _isRunning;

    public WorkerStatus(String name, int sortOrder) {
        this._name = name;
        this._sortOrder = Math.max(0, sortOrder);
    }

    public synchronized String getMessage() {
        return this._msg;
    }

    public WorkerState getStatus() {
        return this._status;
    }

    public boolean getAlive() {
        return this._isRunning;
    }

    public long getExecutionCount() {
        return this._execCount;
    }

    public synchronized void setMessage(String msg) {
        this._msg = msg;
    }

    public void setAlive(boolean isAlive) {
        this._isRunning = isAlive;
    }

    public synchronized void setStatus(WorkerState newStatus) {
        this._status = newStatus;
    }

    public synchronized void execute() {
        this._execStartTime = System.currentTimeMillis();
        this._execStopTime = 0L;
    }

    public synchronized void complete() {
        this._execStopTime = System.currentTimeMillis();
        ++this._execCount;
    }

    public synchronized long getExecutionTime() {
        if (this._execStartTime == 0L) {
            return 0L;
        }
        return (this._execStopTime == 0L ? System.currentTimeMillis() : this._execStopTime) - this._execStartTime;
    }

    public int getSortOrder() {
        return this._sortOrder;
    }

    @Override
    public int compareTo(WorkerStatus ws2) {
        int tmpResult = Integer.compare(this._sortOrder, ws2._sortOrder);
        return tmpResult == 0 ? this._name.compareTo(ws2._name) : tmpResult;
    }

    public boolean equals(Object o) {
        WorkerStatus ws2;
        return o instanceof WorkerStatus && this.compareTo(ws2 = (WorkerStatus)o) == 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this._name;
    }
}

