/*
 * Decompiled with CFR 0.152.
 */
package org.gvagroup.pool;

import org.gvagroup.pool.ConnectionPool;
import org.gvagroup.tomcat.SharedTask;

class ConnectionMonitor<T extends AutoCloseable>
implements SharedTask {
    private static final long serialVersionUID = -5370602877805586773L;
    private final transient ConnectionPool<T> _pool;
    private final String _name;
    private final int _sleepTime;
    private long _poolCheckCount;
    private boolean _isStopped = false;

    ConnectionMonitor(String name, int interval, ConnectionPool<T> pool) {
        this._name = name;
        this._pool = pool;
        this._sleepTime = Math.min(3600, Math.max(10, interval)) * 1000;
    }

    @Override
    public void stop() {
        this._isStopped = true;
    }

    @Override
    public boolean isStopped() {
        return this._isStopped;
    }

    public long getCheckCount() {
        return this._poolCheckCount;
    }

    @Override
    public int getInterval() {
        return this._sleepTime;
    }

    @Override
    public synchronized void execute() {
        ++this._poolCheckCount;
        this._pool.validate();
    }

    public String toString() {
        return String.format("%s %s Connection Monitor", this._name, this._pool.getType());
    }
}

