/*
 * Decompiled with CFR 0.152.
 */
package org.gvagroup.pool;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.gvagroup.pool.ConnectionPoolEntry;
import org.gvagroup.pool.JDBCWrapper;
import org.gvagroup.pool.Recycler;

class JDBCPoolEntry
extends ConnectionPoolEntry<Connection> {
    private static final long serialVersionUID = 986869655819214021L;
    private static final transient int DEFAULT_SERIALIZATION = 2;
    private Properties _props = new Properties();
    private transient String _validationQuery = "SELECT 1";
    private boolean _autoCommit = true;

    JDBCPoolEntry(int id, Recycler<Connection> src, Properties props) {
        super(id, src, JDBCPoolEntry.class);
        if (props.containsKey("validationQuery")) {
            this._validationQuery = props.getProperty("validationQuery");
            props.remove("validationQuery");
        }
        this._props.putAll((Map<?, ?>)props);
    }

    @Override
    public String getType() {
        return "JDBC";
    }

    @Override
    void connect() throws SQLException {
        Connection c;
        Connection connection = c = this.isActive() ? (Connection)this.get() : null;
        if (c != null && !c.isClosed()) {
            throw new IllegalStateException(String.format("Connection %s already Connected", this.toString()));
        }
        Connection con = DriverManager.getConnection(this._props.getProperty("url"), this._props);
        con.setTransactionIsolation(2);
        JDBCWrapper cw = new JDBCWrapper(con, this);
        cw.setAutoCommit(this._autoCommit);
        this.setWrapper(cw);
        this.markConnected();
    }

    @Override
    void free() {
        if (this.checkFree()) {
            return;
        }
        try {
            Connection c = (Connection)this.get();
            if (c != null && c.getAutoCommit() != this._autoCommit) {
                this.log.debug("Resetting autoCommit to {}", (Object)this._autoCommit);
                c.setAutoCommit(this._autoCommit);
                c.setTransactionIsolation(2);
            }
        }
        catch (Exception e) {
            this.log.error("Error resetting autoCommit/isolation on {} - {}", (Object)this.getID(), (Object)e.getMessage());
        }
        this.markFree();
    }

    @Override
    Connection reserve(boolean logStack) {
        this.checkState();
        this.markUsed();
        if (logStack) {
            this.generateStackTrace();
        }
        return (Connection)((Object)this.getWrapper());
    }

    /*
     * Exception decompiling
     */
    @Override
    boolean checkConnection() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void cleanup() throws SQLException {
        Connection c = (Connection)this.get();
        if (!c.getAutoCommit()) {
            c.rollback();
            this.log.debug("Rolling back transactions");
        }
    }

    void setAutoCommit(boolean commit) {
        this._autoCommit = commit;
    }
}

