/*
 * Decompiled with CFR 0.152.
 */
package org.gvagroup.pool;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.gvagroup.pool.ConnectionPoolEntry;
import org.gvagroup.pool.ConnectionWrapper;
import org.gvagroup.pool.JDBCPoolEntry;
import org.gvagroup.pool.PreparedStatementWrapper;

public class JDBCWrapper
implements ConnectionWrapper<Connection>,
Connection {
    private final int _id;
    private long _lastUse;
    private final transient Connection _c;
    private final transient ConnectionPoolEntry<Connection> _entry;
    private boolean _autoCommit;

    JDBCWrapper(Connection c, JDBCPoolEntry cpe) {
        this._id = cpe.getID();
        this._c = c;
        this._entry = cpe;
    }

    private void recordLastUse() {
        this._lastUse = System.currentTimeMillis();
    }

    @Override
    public int getID() {
        return this._id;
    }

    @Override
    public long getLastUse() {
        return this._lastUse;
    }

    @Override
    public Connection get() {
        return this._c;
    }

    @Override
    public void close() {
        this.recordLastUse();
        this._entry.recycle();
    }

    @Override
    public void forceClose() throws Exception {
        this.recordLastUse();
        this._c.close();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.recordLastUse();
        this._c.clearWarnings();
    }

    @Override
    public void commit() throws SQLException {
        this.recordLastUse();
        this._c.commit();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.recordLastUse();
        return this._c.createArrayOf(typeName, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.recordLastUse();
        return this._c.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        this.recordLastUse();
        return this._c.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.recordLastUse();
        return this._c.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.recordLastUse();
        return this._c.createSQLXML();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.recordLastUse();
        return this._c.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.recordLastUse();
        return this._c.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.recordLastUse();
        return this._c.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.recordLastUse();
        return this._c.createStruct(typeName, attributes);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this._autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.recordLastUse();
        return this._c.getCatalog();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.recordLastUse();
        return this._c.getClientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.recordLastUse();
        return this._c.getClientInfo(name);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.recordLastUse();
        return this._c.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.recordLastUse();
        return this._c.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.recordLastUse();
        return this._c.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.recordLastUse();
        return this._c.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.recordLastUse();
        return this._c.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.recordLastUse();
        return this._c.isClosed();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.recordLastUse();
        return this._c.isValid(timeout);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.recordLastUse();
        return this._c.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.recordLastUse();
        return this._c.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.recordLastUse();
        return this._c.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.recordLastUse();
        return this._c.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.recordLastUse();
        PreparedStatement ps = this._c.prepareStatement(sql);
        return new PreparedStatementWrapper(ps);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.recordLastUse();
        PreparedStatement ps = this._c.prepareStatement(sql, autoGeneratedKeys);
        return new PreparedStatementWrapper(ps);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.recordLastUse();
        PreparedStatement ps = this._c.prepareStatement(sql, columnIndexes);
        return new PreparedStatementWrapper(ps);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.recordLastUse();
        PreparedStatement ps = this._c.prepareStatement(sql, columnNames);
        return new PreparedStatementWrapper(ps);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.recordLastUse();
        PreparedStatement ps = this._c.prepareStatement(sql, resultSetType, resultSetConcurrency);
        return new PreparedStatementWrapper(ps);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.recordLastUse();
        PreparedStatement ps = this._c.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return new PreparedStatementWrapper(ps);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.recordLastUse();
        this._c.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.recordLastUse();
        this._c.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.recordLastUse();
        this._c.rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this._autoCommit = autoCommit;
        this.recordLastUse();
        this._c.setAutoCommit(this._autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.recordLastUse();
        this._c.setCatalog(catalog);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.recordLastUse();
        this._c.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.recordLastUse();
        this._c.setClientInfo(name, value);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.recordLastUse();
        this._c.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.recordLastUse();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.recordLastUse();
        return this._c.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.recordLastUse();
        return this._c.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.recordLastUse();
        this._c.setTransactionIsolation(level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> m) throws SQLException {
        this.recordLastUse();
        this._c.setTypeMap(m);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.recordLastUse();
        return this._c.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.recordLastUse();
        return this._c.unwrap(iface);
    }

    @Override
    public int compareTo(ConnectionWrapper<Connection> cw2) {
        return Integer.compare(this.getID(), cw2.getID());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "JDBCWrapper-" + String.valueOf(this.getID());
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.recordLastUse();
        this._c.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.recordLastUse();
        return this._c.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.recordLastUse();
        this._c.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.recordLastUse();
        this._c.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.recordLastUse();
        return this._c.getNetworkTimeout();
    }
}

