/*
 * Decompiled with CFR 0.152.
 */
package org.gvagroup.pool;

import org.gvagroup.pool.ConnectionPool;
import org.gvagroup.pool.ConnectionPoolEntry;
import org.gvagroup.pool.JedisPoolEntry;
import redis.clients.jedis.Jedis;

public class JedisPool
extends ConnectionPool<Jedis> {
    private static final long serialVersionUID = 479597434632122740L;

    public JedisPool(int maxSize, String name) {
        super(maxSize, name, 40, JedisPool.class);
        this.setWaitTime(5, 50);
    }

    @Override
    int getStaleTime() {
        return 5000;
    }

    @Override
    public String getType() {
        return "Jedis";
    }

    @Override
    protected ConnectionPoolEntry<Jedis> createConnection(int id) throws Exception {
        String url = this._props.getProperty("socketFile", this._props.getProperty("addr"));
        this.log.info("{} connecting to {} ID #{}", (Object)this.getName(), (Object)url, (Object)id);
        JedisPoolEntry entry = new JedisPoolEntry(id, this, this._props);
        entry.connect();
        return entry;
    }
}

