/*
 * Decompiled with CFR 0.152.
 */
package org.gvagroup.pool;

import org.gvagroup.pool.ConnectionPoolEntry;
import org.gvagroup.pool.ConnectionWrapper;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisSocketFactory;

public class JedisWrapper
extends Jedis
implements ConnectionWrapper<Jedis> {
    private final int _id;
    private long _lastUse;
    private final transient ConnectionPoolEntry<Jedis> _entry;

    JedisWrapper(String addr, int port, ConnectionPoolEntry<Jedis> cpe) {
        super(addr, port);
        this._id = cpe.getID();
        this._entry = cpe;
    }

    JedisWrapper(JedisSocketFactory sf, JedisClientConfig cfg, ConnectionPoolEntry<Jedis> cpe) {
        super(sf, cfg);
        this._id = cpe.getID();
        this._entry = cpe;
    }

    @Override
    public int getID() {
        return this._id;
    }

    @Override
    public long getLastUse() {
        return this._lastUse;
    }

    @Override
    public Jedis get() {
        return this;
    }

    private void recordLastUse() {
        this._lastUse = System.currentTimeMillis();
    }

    @Override
    public void close() {
        this.recordLastUse();
        this._entry.recycle();
    }

    @Override
    public void forceClose() throws Exception {
        this.recordLastUse();
        super.close();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("JedisWrapper-");
        return buf.append(this._id).toString();
    }
}

