/*
 * Decompiled with CFR 0.152.
 */
package org.gvagroup.tomcat;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gvagroup.tomcat.SharedTask;

public class SharedWorker
implements Runnable {
    private static final Logger log = LogManager.getLogger(SharedWorker.class);
    private static final BlockingQueue<QueueEntry> _tasks = new DelayQueue<QueueEntry>();
    private static final Random _rnd = new Random();

    public static void register(SharedTask t) {
        _tasks.add(new QueueEntry(t));
    }

    public static void clear(ClassLoader cl) {
        Iterator i = _tasks.iterator();
        while (i.hasNext()) {
            SharedTask t = ((QueueEntry)i.next()).getTask();
            if (!t.isStopped() && t.getClass().getClassLoader() != cl) continue;
            log.info("Removed task {}", (Object)t);
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeTask(QueueEntry e) {
        SharedTask t = e.getTask();
        if (t.isStopped()) {
            log.warn("{} stopped", (Object)t);
            return;
        }
        log.debug("Executing {} - #{}", (Object)t, (Object)e.getExecutionCount());
        long tt = System.currentTimeMillis();
        try {
            t.execute();
            e.reset();
            _tasks.add(e);
        }
        catch (Exception ex) {
            log.atError().withThrowable((Throwable)ex).log("{} executing {}", (Object)ex.getMessage(), (Object)t);
        }
        finally {
            long execTime = System.currentTimeMillis() - tt;
            if (execTime > 2500L) {
                log.warn("Execess execution time for {} - {}ms", (Object)t, (Object)execTime);
            }
        }
    }

    @Override
    public void run() {
        log.info("Starting");
        while (!Thread.currentThread().isInterrupted()) {
            QueueEntry qe = null;
            try {
                qe = _tasks.poll(20L, TimeUnit.SECONDS);
                if (qe == null) continue;
                SharedWorker.executeTask(qe);
            }
            catch (InterruptedException ie) {
                log.info("Interrupted");
                Thread.currentThread().interrupt();
            }
        }
        _tasks.clear();
        log.info("Stopped");
    }

    private static class QueueEntry
    implements Delayed,
    Serializable {
        private static final long serialVersionUID = -4506885278758091086L;
        private final SharedTask _t;
        private long _nextExec;
        private int _execCount;

        QueueEntry(SharedTask t) {
            this._t = t;
            this._nextExec = System.currentTimeMillis() + (long)t.getInterval() + (long)_rnd.nextInt(t.getInterval() / 10);
        }

        SharedTask getTask() {
            return this._t;
        }

        public int getExecutionCount() {
            return this._execCount;
        }

        void reset() {
            this._nextExec = System.currentTimeMillis() + (long)this._t.getInterval();
            ++this._execCount;
        }

        @Override
        public int compareTo(Delayed d2) {
            return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), d2.getDelay(TimeUnit.MILLISECONDS));
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long execDelta = this._nextExec - System.currentTimeMillis();
            return unit.convert(execDelta, TimeUnit.MILLISECONDS);
        }
    }
}

