/*
 * Decompiled with CFR 0.152.
 */
package org.gvagroup.tomcat;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gvagroup.tomcat.AbstractLifecycleListener;
import org.gvagroup.tomcat.SharedWorker;

public class SharedWorkerListener
extends AbstractLifecycleListener
implements Thread.UncaughtExceptionHandler {
    private static final String THREAD_NAME = "Golgotha Shared Worker";
    private Logger log;
    private Thread _wt;

    @Override
    void onStartup(boolean isAfter) {
        if (isAfter) {
            return;
        }
        this.log = LogManager.getLogger(SharedWorker.class);
        this._wt = Thread.ofVirtual().name(THREAD_NAME).unstarted(new SharedWorker());
        this._wt.setUncaughtExceptionHandler(this);
        this._wt.setDaemon(true);
        this._wt.start();
    }

    @Override
    void onShutdown(boolean isAfter) {
        if (isAfter) {
            return;
        }
        this._wt.interrupt();
        try {
            this._wt.join(1250L);
        }
        catch (InterruptedException ie) {
            this.log.warn("Timed out waiting for SharedWorker termination");
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (t != this._wt) {
            this.log.atError().withThrowable(e).log("Unknown thread - {}", (Object)t.getName());
            return;
        }
        this._wt = Thread.ofVirtual().name(THREAD_NAME).unstarted(new SharedWorker());
        this._wt.setUncaughtExceptionHandler(this);
        this._wt.setDaemon(true);
        this._wt.start();
        this.log.atError().withThrowable(e).log("Restarted {}", (Object)t.getName());
    }
}

