/*
 * Decompiled with CFR 0.152.
 */
package com.feldt.metar;

import com.feldt.metar.tools.Convert;

class Cloud {
    private String amount;
    private String type;
    private Integer height;

    private Cloud() {
    }

    public static boolean isACloud(String metarString) {
        if (metarString == null) {
            return false;
        }
        char[] buf = metarString.toCharArray();
        int i = 0;
        if (buf.length == 3 && (metarString.equals("SKC") || metarString.equals("CLR"))) {
            return true;
        }
        if (metarString.startsWith("VV")) {
            i += 2;
        } else if (metarString.startsWith("FEW") || metarString.startsWith("SCT") || metarString.startsWith("BKN") || metarString.startsWith("OVC")) {
            i += 3;
        } else {
            return false;
        }
        if (i + 3 <= buf.length) {
            int endIndex = i + 3;
            for (int j = i; j < endIndex; ++j) {
                if (Character.isDigit(buf[j])) continue;
                return false;
            }
        } else {
            return false;
        }
        if ((i += 3) == buf.length) {
            return true;
        }
        return metarString.substring(i).equals("TCU") || metarString.substring(i).equals("CB");
    }

    public static Cloud parseCloud(String metarString) {
        if (!Cloud.isACloud(metarString)) {
            return null;
        }
        Cloud cloud = new Cloud();
        int i = 0;
        if (metarString.startsWith("VV")) {
            cloud.setAmount(metarString.substring(0, 2));
            i += 2;
        } else {
            cloud.setAmount(metarString.substring(0, 3));
            i += 3;
        }
        if (i + 3 <= metarString.length()) {
            cloud.setHeight(new Integer(metarString.substring(i, i + 3)));
            i += 3;
        }
        if (i < metarString.length()) {
            cloud.setType(metarString.substring(i));
        }
        return cloud;
    }

    public static String lookupCloudAmount(String s) {
        if (s.equals("SKC")) {
            return "clear sky";
        }
        if (s.equals("CLR")) {
            return "clear sky";
        }
        if (s.equals("FEW")) {
            return "few clouds";
        }
        if (s.equals("SCT")) {
            return "scattered clouds";
        }
        if (s.equals("BKN")) {
            return "broken clouds";
        }
        if (s.equals("OVC")) {
            return "overcast";
        }
        if (s.equals("VV")) {
            return "vertical visibility";
        }
        return s;
    }

    public static String lookupCloudType(String s) {
        if (s.equals("TCU")) {
            return "towering cumulus";
        }
        if (s.equals("CB")) {
            return "cumulonimbus";
        }
        return s;
    }

    public String getFormattedCloud() {
        StringBuffer s = new StringBuffer();
        if (this.amount != null) {
            s.append(Cloud.lookupCloudAmount(this.amount));
        }
        if (this.height != null) {
            s.append(" at " + Integer.toString(this.height * 100) + " feet");
        }
        if (this.type != null) {
            s.append(" (" + Cloud.lookupCloudType(this.type) + ")");
        }
        return s.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        if (this.amount != null) {
            s.append(this.amount);
        }
        if (this.height != null) {
            s.append(Convert.zeroPadInt(this.height, 3));
        }
        if (this.type != null) {
            s.append(this.type);
        }
        return s.toString();
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

