/*
 * Decompiled with CFR 0.152.
 */
package com.feldt.metar;

import com.feldt.metar.Altimeter;
import com.feldt.metar.Cloud;
import com.feldt.metar.Condition;
import com.feldt.metar.Temperature;
import com.feldt.metar.Visibility;
import com.feldt.metar.Wind;
import com.feldt.metar.exceptions.MetarParseException;
import com.feldt.metar.tools.Convert;
import java.io.FileInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class Metar {
    private String station;
    private Date date;
    private Wind wind;
    private Visibility visibility;
    private Vector conditions = new Vector();
    private Vector clouds = new Vector();
    private Temperature temperature;
    private Altimeter altimeter;
    private Boolean corrected = Boolean.FALSE;

    private Metar() {
    }

    public static boolean isDate(String date) {
        if (date == null) {
            return false;
        }
        return date.matches("\\d{6}Z");
    }

    public static boolean metarReportDateMatches(String in, String metarReportDate) {
        if (in == null || metarReportDate == null) {
            return false;
        }
        if (!in.matches("\\d{6}Z")) {
            return false;
        }
        if (!metarReportDate.matches("\\d{4}/\\d{2}/\\d{2} \\d{2}:\\d{2}")) {
            return false;
        }
        if (!metarReportDate.substring(8, 10).equals(in.substring(0, 2))) {
            return false;
        }
        if (!metarReportDate.substring(11, 13).equals(in.substring(2, 4))) {
            return false;
        }
        return metarReportDate.substring(14, 16).equals(in.substring(4, 6));
    }

    private void parseDate(String metarReportDate) {
        if (metarReportDate == null) {
            return;
        }
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd kk:mm");
        sdf.setTimeZone(tz);
        sdf.setLenient(false);
        try {
            this.date = sdf.parse(metarReportDate);
            if (this.date != null) {
                GregorianCalendar gc = new GregorianCalendar(tz);
                gc.setTime(this.date);
                this.date = gc.getTime();
            }
        }
        catch (ParseException e) {
            // empty catch block
        }
    }

    public static Metar parse(String station, String metarData, String metarReportDate) throws MetarParseException {
        if (station == null || metarData == null) {
            return null;
        }
        Metar metar = new Metar();
        StringTokenizer st = new StringTokenizer(metarData);
        String lastToken = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase(station)) {
                metar.setStation(station.toUpperCase());
                continue;
            }
            if (token.equals("RMK")) break;
            if (token.equals("COR")) {
                metar.setCorrected(Boolean.TRUE);
                continue;
            }
            if (Metar.isDate(token)) {
                if (Metar.metarReportDateMatches(token, metarReportDate)) {
                    metar.parseDate(metarReportDate);
                    continue;
                }
                throw new MetarParseException("Date token: \"" + token + "\" does not match metar report date: " + metarReportDate);
            }
            if (Wind.isAWind(token)) {
                metar.setWind(Wind.parseWind(token));
                continue;
            }
            if (Wind.isVariable(token)) {
                metar.getWind().setVariable(token);
                continue;
            }
            if (Temperature.isATemperature(token)) {
                metar.setTemperature(Temperature.parseTemperature(token));
                continue;
            }
            if (Condition.isACondition(token)) {
                metar.addCondition(Condition.parseCondition(token));
                continue;
            }
            if (Cloud.isACloud(token)) {
                metar.addCloud(Cloud.parseCloud(token));
                continue;
            }
            if (Altimeter.isAAltimeter(token)) {
                metar.setAltimeter(Altimeter.parseAltimeter(token));
                continue;
            }
            if (lastToken != null && !Visibility.isAVisibility(token)) {
                throw new MetarParseException("Unknown token: \"" + lastToken + "\" in \"" + metarData + "\"");
            }
            if (Visibility.isAVisibility(token)) {
                if (lastToken != null) {
                    metar.setVisibility(Visibility.parseVisibility(lastToken + " " + token));
                    lastToken = null;
                    continue;
                }
                metar.setVisibility(Visibility.parseVisibility(token));
                continue;
            }
            if (metar.visibility == null && Convert.isPositiveInteger(token)) {
                lastToken = token;
                continue;
            }
            throw new MetarParseException("Unknown token: \"" + token + "\" in \"" + metarData + "\"");
        }
        return metar;
    }

    public String getFormattedDate(boolean detailed) {
        if (this.date == null) {
            return "";
        }
        if (detailed) {
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy hh:mm a z");
            return sdf.format(this.date);
        }
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat sdf = new SimpleDateFormat("ddHHmm");
        sdf.setTimeZone(tz);
        return sdf.format(this.date) + "Z";
    }

    public String getFormattedConditions() {
        if (this.conditions.size() <= 0) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.conditions.size(); ++i) {
            Condition condition = (Condition)this.conditions.get(i);
            s.append(condition.getFormattedCondition());
            if (i + 1 >= this.conditions.size()) continue;
            s.append(", ");
        }
        return s.toString();
    }

    public String getFormattedClouds() {
        if (this.clouds.size() <= 0) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.clouds.size(); ++i) {
            s.append(((Cloud)this.clouds.get(i)).getFormattedCloud());
            if (i + 1 >= this.clouds.size()) continue;
            s.append(", ");
        }
        return s.toString();
    }

    public String getFormattedMetar() {
        StringBuffer s = new StringBuffer();
        String newLine = System.getProperty("line.separator");
        if (this.station != null) {
            String formattedStation = this.station;
            try {
                Properties metarProperties = new Properties();
                metarProperties.load(new FileInputStream("metar.properties"));
                formattedStation = (String)metarProperties.get(this.station);
                if (formattedStation == null) {
                    formattedStation = this.station;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            s.append("Conditions at: " + formattedStation + newLine);
        }
        if (this.date != null) {
            s.append("Time: " + this.getFormattedDate(true) + newLine);
        }
        if (this.wind != null) {
            s.append("Wind: " + this.wind.getFormattedWind() + newLine);
        }
        if (this.visibility != null) {
            s.append("Visibility: " + this.visibility.getFormattedVisibility() + newLine);
        }
        if (this.conditions.size() > 0) {
            s.append("Weather Conditions: " + this.getFormattedConditions() + newLine);
        }
        if (this.clouds.size() > 0) {
            s.append("Sky Conditions: " + this.getFormattedClouds() + newLine);
        }
        if (this.temperature != null) {
            s.append("Temperature: " + this.temperature.getFormattedTemperature() + newLine);
            s.append("Dew Point: " + this.temperature.getFormattedDewPoint() + newLine);
            s.append("Relative Humidity: " + this.temperature.getFormattedHumidity() + newLine);
        }
        if (this.altimeter != null) {
            s.append("Pressure (altimeter): " + this.altimeter.getFormattedAltimeter() + newLine);
        }
        return s.toString();
    }

    public String toString() {
        int i;
        StringBuffer s = new StringBuffer();
        if (this.station != null) {
            s.append(this.station + " ");
        }
        if (this.date != null) {
            s.append(this.getFormattedDate(false) + " ");
        }
        if (this.corrected.booleanValue()) {
            s.append("COR ");
        }
        if (this.wind != null) {
            s.append(this.wind.toString() + " ");
        }
        if (this.visibility != null) {
            s.append(this.visibility.toString() + " ");
        }
        if (this.conditions.size() > 0) {
            StringBuffer conditionString = new StringBuffer();
            for (i = 0; i < this.conditions.size(); ++i) {
                Condition condition = (Condition)this.conditions.get(i);
                conditionString.append(condition.toString());
                if (i + 1 >= this.conditions.size()) continue;
                conditionString.append(" ");
            }
            s.append(conditionString.toString() + " ");
        }
        if (this.clouds.size() > 0) {
            StringBuffer cloudString = new StringBuffer();
            for (i = 0; i < this.clouds.size(); ++i) {
                Cloud cloud = (Cloud)this.clouds.get(i);
                cloudString.append(cloud.toString());
                if (i + 1 >= this.clouds.size()) continue;
                cloudString.append(" ");
            }
            s.append(cloudString.toString() + " ");
        }
        if (this.temperature != null) {
            s.append(this.temperature.toString() + " ");
        }
        if (this.altimeter != null) {
            s.append(this.altimeter.toString());
        }
        return s.toString();
    }

    public String getStation() {
        return this.station;
    }

    public void setStation(String station) {
        this.station = station;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = (Date)date.clone();
    }

    public Vector getConditions() {
        return this.conditions;
    }

    public void setConditions(Vector conditions) {
        this.conditions = conditions;
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
    }

    public Vector getClouds() {
        return this.clouds;
    }

    public void setClouds(Vector clouds) {
        this.clouds = clouds;
    }

    public void addCloud(Cloud cloud) {
        this.clouds.add(cloud);
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Wind getWind() {
        return this.wind;
    }

    public void setWind(Wind wind) {
        this.wind = wind;
    }

    public Altimeter getAltimeter() {
        return this.altimeter;
    }

    public void setAltimeter(Altimeter altimeter) {
        this.altimeter = altimeter;
    }

    public Boolean getCorrected() {
        return this.corrected;
    }

    public void setCorrected(Boolean corrected) {
        this.corrected = corrected;
    }

    public Temperature getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Temperature temperature) {
        this.temperature = temperature;
    }
}

