/*
 * Decompiled with CFR 0.152.
 */
package com.feldt.metar;

import com.feldt.metar.exceptions.MetarException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;

public class MetarFtp {
    private Date observationDate;
    private String observation;

    private MetarFtp() {
    }

    public static MetarFtp parse(String station) throws MetarException {
        if (station == null) {
            return null;
        }
        try {
            Properties metarProperties = new Properties();
            metarProperties.load(new FileInputStream("metar.properties"));
            String urlString = metarProperties.getProperty("ftpURL");
            if (urlString == null) {
                throw new Exception("Unable to find ftpURL property in property.file.");
            }
            urlString = urlString.concat(station.toUpperCase().concat(".TXT"));
            URL url = new URL(urlString);
            URLConnection conn = url.openConnection();
            conn.setDoInput(true);
            conn.connect();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            MetarFtp metarFtp = new MetarFtp();
            String buf = reader.readLine();
            if (buf == null) {
                throw new Exception("no data in InputStream");
            }
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd kk:mm");
            sdf.setTimeZone(tz);
            sdf.setLenient(false);
            Date date = sdf.parse(buf);
            if (date == null) {
                throw new Exception("unable to parse date from InputStream");
            }
            GregorianCalendar gc = new GregorianCalendar(tz);
            gc.setTime(date);
            metarFtp.setObservationDate(gc.getTime());
            StringBuffer out = new StringBuffer();
            while ((buf = reader.readLine()) != null) {
                out.append(buf);
            }
            if (out.length() <= 0) {
                throw new IOException("no observation string in InputStream");
            }
            metarFtp.setObservation(out.toString());
            return metarFtp;
        }
        catch (Exception e) {
            throw new MetarException(e.getMessage());
        }
    }

    public void setObservationDate(Date observationDate) {
        this.observationDate = (Date)observationDate.clone();
    }

    public Date getObservationDate() {
        return this.observationDate;
    }

    public String getObservationDateAsString() {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd kk:mm");
        sdf.setTimeZone(tz);
        return sdf.format(this.observationDate);
    }

    public void setObservation(String observation) {
        this.observation = observation;
    }

    public String getObservation() {
        return this.observation;
    }
}

