/*
 * Decompiled with CFR 0.152.
 */
package com.feldt.metar;

import com.feldt.metar.Metar;
import com.feldt.metar.MetarFtp;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class MetarRun {
    public static void main(String[] args) {
        String[] remainingArgs;
        String usage = "Usage: java -jar metar-app-1.0.jar [{-p,--print-details}] [{-f,--ftp}] " + System.getProperty("line.separator") + "       [{-i,--input-file} filename] [--help] station";
        Metar metar = null;
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option detailOption = parser.addBooleanOption('p', "print-details");
        CmdLineParser.Option ftpOption = parser.addBooleanOption('f', "ftp");
        CmdLineParser.Option fileOption = parser.addStringOption('i', "input-file");
        CmdLineParser.Option helpOption = parser.addBooleanOption("help");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            System.err.println(usage);
            System.exit(-1);
        }
        Boolean helpValue = (Boolean)parser.getOptionValue(helpOption);
        if (helpValue != null && helpValue.booleanValue()) {
            System.out.println();
            System.out.println(usage);
            System.out.println();
            System.out.println("  Station names can be found in metar.properties or from the");
            System.out.println("  offical source at: http://weather.noaa.gov/data/nsd_bbsss.txt");
            System.out.println();
            System.out.println("  -f,--ftp             fetch metar data via ftp");
            System.out.println("  -i,--input-file      read metar data from the specified file");
            System.out.println("  -p,--print-details   print parsed and converted metar data");
            System.out.println("  --help               this handy and helpful message");
            System.out.println();
            System.exit(0);
        }
        if ((remainingArgs = parser.getRemainingArgs()).length != 1) {
            System.err.println(usage);
            System.exit(-1);
        }
        String station = remainingArgs[0].toUpperCase();
        try {
            MetarFtp metarFtp;
            String inputFile;
            Boolean ftpValue;
            Boolean detailValue = (Boolean)parser.getOptionValue(detailOption);
            if (detailValue == null) {
                detailValue = Boolean.FALSE;
            }
            if ((ftpValue = (Boolean)parser.getOptionValue(ftpOption)) == null) {
                ftpValue = Boolean.FALSE;
            }
            if ((inputFile = (String)parser.getOptionValue(fileOption)) != null) {
                String data;
                boolean foundMetarData = false;
                String metarDate = null;
                String matcher = "\\d{4}/\\d{2}/\\d{2} \\d{2}:\\d{2}";
                File f = new File(inputFile);
                if (!f.isFile() || !f.canRead()) {
                    throw new Exception(f.getPath() + ": does not exist or can not be read.");
                }
                BufferedReader in = new BufferedReader(new FileReader(f));
                while ((data = in.readLine()) != null) {
                    if (data.matches(matcher)) {
                        metarDate = data;
                    }
                    if (!data.startsWith(station) || metarDate == null) continue;
                    foundMetarData = true;
                    if (data.substring(data.length() - 5).equals("=<BR>")) {
                        data = data.substring(0, data.length() - 5);
                    }
                    metar = Metar.parse(station, data, metarDate);
                    break;
                }
                if (foundMetarData && metar != null) {
                    if (detailValue.booleanValue()) {
                        System.out.println(metar.getFormattedMetar());
                    } else {
                        System.out.println(metar.toString());
                    }
                } else {
                    System.out.println("No metar data file in file.");
                }
            } else if (ftpValue.booleanValue() && (metar = Metar.parse(station, (metarFtp = MetarFtp.parse(station)).getObservation(), metarFtp.getObservationDateAsString())) != null) {
                if (detailValue.booleanValue()) {
                    System.out.println(metar.getFormattedMetar());
                } else {
                    System.out.println(metar.toString());
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

