/*
 * Decompiled with CFR 0.152.
 */
package com.feldt.metar;

import com.feldt.metar.tools.Convert;

class Temperature {
    private Integer temperature;
    private Integer dewPoint;
    private Integer humidity;

    private Temperature() {
    }

    public static boolean isATemperature(String metarString) {
        if (metarString == null) {
            return false;
        }
        char[] buf = metarString.toCharArray();
        int i = 0;
        if (buf.length < 5) {
            return false;
        }
        if (buf[i] == 'M') {
            ++i;
        }
        if (!Character.isDigit(buf[i]) || !Character.isDigit(buf[++i])) {
            return false;
        }
        if (buf[++i] != '/') {
            return false;
        }
        if (buf[++i] == 'M') {
            ++i;
        }
        return Character.isDigit(buf[i]) && Character.isDigit(buf[++i]);
    }

    public static Temperature parseTemperature(String metarString) {
        if (!Temperature.isATemperature(metarString)) {
            return null;
        }
        Temperature temperature = new Temperature();
        char[] buf = metarString.toCharArray();
        int i = 0;
        boolean minus = false;
        if (buf[0] == 'M') {
            minus = true;
            ++i;
        }
        int j = i;
        while (buf[j] != '/') {
            ++j;
        }
        int value = Convert.bytesToInt(buf, i, j);
        if (minus) {
            value = -value;
        }
        temperature.setTemperature(new Integer(value));
        minus = false;
        i = j + 1;
        if (buf[i] == 'M') {
            minus = true;
            ++i;
        }
        value = Convert.bytesToInt(buf, i, buf.length);
        if (minus) {
            value = -value;
        }
        temperature.setDewPoint(new Integer(value));
        temperature.humidity = new Integer(Convert.calcHumidity(temperature.getTemperature(), temperature.getDewPoint()));
        return temperature;
    }

    public String getFormattedTemperature() {
        StringBuffer s = new StringBuffer();
        if (this.temperature != null) {
            s.append(Convert.cToF(this.temperature) + " F (" + this.temperature + " C)");
        }
        return s.toString();
    }

    public String getFormattedDewPoint() {
        StringBuffer s = new StringBuffer();
        if (this.dewPoint != null) {
            s.append(Convert.cToF(this.dewPoint) + " F (" + this.dewPoint + " C)");
        }
        return s.toString();
    }

    public String getFormattedHumidity() {
        return this.humidity.toString() + "%";
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        if (this.temperature != null) {
            int temp = this.temperature;
            if (temp < 0) {
                s.append("M");
                temp = -temp;
            }
            s.append(Convert.zeroPadInt(temp, 2));
            s.append("/");
        }
        if (this.dewPoint != null) {
            int dewp = this.dewPoint;
            if (dewp < 0) {
                s.append("M");
                dewp = -dewp;
            }
            s.append(Convert.zeroPadInt(dewp, 2));
        }
        return s.toString();
    }

    public Integer getDewPoint() {
        return this.dewPoint;
    }

    public void setDewPoint(Integer dewPoint) {
        this.dewPoint = dewPoint;
    }

    public Integer getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Integer temperature) {
        this.temperature = temperature;
    }

    public Integer getHumidity() {
        return this.humidity;
    }

    public void setHumidity(Integer humidity) {
        this.humidity = humidity;
    }
}

