/*
 * Decompiled with CFR 0.152.
 */
package com.feldt.metar;

import com.feldt.metar.tools.Convert;

class Visibility {
    private String visibility;
    private boolean lessThan;

    private Visibility() {
    }

    public static boolean isAVisibility(String metarString) {
        if (metarString == null) {
            return false;
        }
        char[] buf = metarString.toCharArray();
        int i = 0;
        boolean foundDigit = false;
        boolean foundSpace = false;
        boolean foundFraction = false;
        int lastChar = 48;
        if (buf.length < 3 || buf[buf.length - 2] != 'S' || buf[buf.length - 1] != 'M') {
            return false;
        }
        if (buf[0] == 'M') {
            ++i;
        }
        while (i < buf.length - 2) {
            if (Character.isDigit(buf[i])) {
                foundDigit = true;
            } else if (buf[i] == ' ') {
                if (foundSpace || lastChar == 47) {
                    return false;
                }
                foundDigit = false;
                foundSpace = true;
            } else if (buf[i] == '/') {
                if (foundFraction || lastChar == 32) {
                    return false;
                }
                foundDigit = false;
                foundFraction = true;
            } else {
                return false;
            }
            lastChar = buf[i];
            ++i;
        }
        return foundDigit;
    }

    public static Visibility parseVisibility(String metarString) {
        Visibility visibility = new Visibility();
        int beginIndex = 0;
        int endIndex = metarString.length() - 2;
        if (metarString.charAt(beginIndex) == 'M') {
            visibility.setLessThan(true);
            ++beginIndex;
        }
        visibility.setVisibility(metarString.substring(beginIndex, endIndex));
        return visibility;
    }

    public String getFormattedVisibility() {
        StringBuffer s = new StringBuffer();
        if (this.lessThan) {
            s.append("Less than ");
        }
        if (this.visibility != null) {
            s.append(this.visibility + " mile(s) (");
            s.append(Convert.smToKm(Convert.mixedToFloat(this.visibility)) + " km)");
        }
        return s.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        if (this.lessThan) {
            s.append("M");
        }
        if (this.visibility != null) {
            s.append(this.visibility + "SM");
        }
        return s.toString();
    }

    private void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getVisibility() {
        return this.visibility;
    }

    private void setLessThan(boolean lessThan) {
        this.lessThan = lessThan;
    }

    public boolean isLessThan() {
        return this.lessThan;
    }
}

