/*
 * Decompiled with CFR 0.152.
 */
package com.feldt.metar;

import com.feldt.metar.tools.Convert;

public class Wind {
    private Integer direction;
    private Integer gust;
    private Integer speed;
    private Integer variesFrom;
    private Integer variesTo;

    private Wind() {
    }

    private String directionLookup(int degrees) {
        if (degrees == 0) {
            return "Calm";
        }
        if (degrees >= 1 && degrees <= 10) {
            return "N";
        }
        if (degrees >= 11 && degrees <= 34) {
            return "NNE";
        }
        if (degrees >= 35 && degrees <= 55) {
            return "NE";
        }
        if (degrees >= 56 && degrees <= 79) {
            return "ENE";
        }
        if (degrees >= 80 && degrees <= 100) {
            return "E";
        }
        if (degrees >= 101 && degrees <= 124) {
            return "ESE";
        }
        if (degrees >= 125 && degrees <= 145) {
            return "SE";
        }
        if (degrees >= 146 && degrees <= 169) {
            return "SSE";
        }
        if (degrees >= 170 && degrees <= 190) {
            return "S";
        }
        if (degrees >= 191 && degrees <= 214) {
            return "SSW";
        }
        if (degrees >= 215 && degrees <= 235) {
            return "SW";
        }
        if (degrees >= 236 && degrees <= 259) {
            return "WSW";
        }
        if (degrees >= 260 && degrees <= 280) {
            return "W";
        }
        if (degrees >= 281 && degrees <= 304) {
            return "WNW";
        }
        if (degrees >= 305 && degrees <= 325) {
            return "NW";
        }
        if (degrees >= 326 && degrees <= 349) {
            return "NNW";
        }
        if (degrees >= 350 && degrees <= 360) {
            return "N";
        }
        if (degrees == -1) {
            return "Variable";
        }
        return "Unknown";
    }

    public static boolean isAWind(String metarString) {
        if (metarString == null) {
            return false;
        }
        char[] buf = metarString.toCharArray();
        boolean isVar = false;
        if (buf.length < 7) {
            return false;
        }
        if (buf[0] == 'V' ? buf[1] != 'R' || buf[2] != 'B' : !Character.isDigit(buf[0]) || !Character.isDigit(buf[1]) || !Character.isDigit(buf[2])) {
            return false;
        }
        if (!Character.isDigit(buf[3]) || !Character.isDigit(buf[4])) {
            return false;
        }
        int i = 5;
        if (Character.isDigit(buf[i])) {
            ++i;
        }
        if (buf[i] == 'G') {
            int j = 1;
            while (Character.isDigit(buf[i + j]) && i + j < buf.length) {
                ++j;
            }
            if (j == 3 || j == 4) {
                i += j;
            } else {
                return false;
            }
        }
        if (i + 2 != buf.length) {
            return false;
        }
        return buf[i] != 'K' || buf[i + 1] == 'T';
    }

    public static Wind parseWind(String metarString) {
        Wind wind = new Wind();
        char[] buf = metarString.toCharArray();
        wind.direction = buf[0] == 'V' ? new Integer(-1) : new Integer(Convert.bytesToInt(buf, 0, 3));
        int i = 3;
        while (Convert.isDigit(buf[i])) {
            ++i;
        }
        wind.speed = new Integer(Convert.bytesToInt(buf, 3, i));
        if (buf[i] == 'G') {
            int j = ++i;
            while (Convert.isDigit(buf[j])) {
                ++j;
            }
            wind.gust = new Integer(Convert.bytesToInt(buf, i, j));
        }
        return wind;
    }

    public static boolean isVariable(String in) {
        int i;
        char[] buf = in.toCharArray();
        if (buf.length != 7) {
            return false;
        }
        for (i = 0; i < 3; ++i) {
            if (Character.isDigit(buf[i])) continue;
            return false;
        }
        if (buf[3] != 'V') {
            return false;
        }
        for (i = 4; i < 7; ++i) {
            if (Character.isDigit(buf[i])) continue;
            return false;
        }
        return true;
    }

    public String getVariable() {
        return Convert.zeroPadInt(this.variesFrom, 3) + "V" + Convert.zeroPadInt(this.variesTo, 3);
    }

    public void setVariable(String in) {
        if (Wind.isVariable(in)) {
            this.variesFrom = new Integer(in.substring(0, 3));
            this.variesTo = new Integer(in.substring(4, 7));
        }
    }

    public String getFormattedWind() {
        StringBuffer s = new StringBuffer();
        if (this.direction != null) {
            if (this.direction == 0) {
                s.append("calm");
            } else if (this.direction == -1) {
                s.append("varies");
            } else {
                s.append("from the " + this.directionLookup(this.direction) + " (" + this.direction + " degrees)");
            }
            s.append(" at " + Convert.ktToMph(this.speed) + " mph (" + this.speed + " knots; " + Convert.ktToMps(this.speed) + " m/s)");
        }
        if (this.gust != null) {
            s.append(" gusting to " + this.gust);
        }
        if (this.variesFrom != null && this.variesTo != null) {
            s.append(", varying from " + this.directionLookup(this.variesFrom) + " (" + this.variesFrom + " degrees) to " + this.directionLookup(this.variesTo) + " (" + this.variesTo + " degrees)");
        }
        return s.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        if (this.direction != null) {
            s = this.direction == -1 ? s.append("VRB") : s.append(Convert.zeroPadInt(this.direction, 3));
        }
        if (this.speed != null) {
            s.append(Convert.zeroPadInt(this.speed, 2));
        }
        if (this.gust != null) {
            s.append("G" + Convert.zeroPadInt(this.gust, 2));
        }
        if (s.length() > 0) {
            s.append("KT");
        }
        if (this.variesFrom != null && this.variesTo != null) {
            s.append(" " + this.getVariable());
        }
        return s.toString();
    }
}

