/*
 * Decompiled with CFR 0.152.
 */
package com.feldt.metar.tools;

import java.util.StringTokenizer;

public class Convert {
    public static int fToC(int f) {
        return (int)((double)(f - 32) * 0.55555556);
    }

    public static int cToF(int c) {
        return (int)((double)c * 1.8 + 32.0);
    }

    public static int ktToMph(int k) {
        return (int)((double)k * 1.1507794);
    }

    public static int ktToMps(int k) {
        return (int)((double)k * 0.514444);
    }

    public static int smToKm(int m) {
        return (int)((double)m * 1.6092);
    }

    public static float smToKm(float f) {
        return f * 1.6092f;
    }

    public static float hPaToInches(float h) {
        return (float)((double)h * 0.02952875);
    }

    public static float inchesToHPa(float i) {
        return (float)((double)i * 33.8653);
    }

    public static int calcHumidity(int t, int d) {
        double temp1 = 6.11 * Math.pow(10.0, 7.5 * (double)t / (237.7 + (double)t));
        double temp2 = 6.11 * Math.pow(10.0, 7.5 * (double)d / (237.7 + (double)d));
        return (int)(temp2 / temp1 * 100.0);
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isPositiveInteger(String s) {
        try {
            if (Integer.parseInt(s) >= 0) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public static int bytesToInt(char[] buf) {
        return Convert.bytesToInt(buf, 0, buf.length);
    }

    public static int bytesToInt(char[] buf, int begin, int end) {
        int sum = 0;
        if (end > buf.length) {
            end = buf.length;
        }
        for (int i = begin; i < end; ++i) {
            sum = sum * 10 + (buf[i] - 48);
        }
        return sum;
    }

    public static String zeroPadInt(int x, int len) {
        String s = Integer.toString(x);
        if (s.length() < len) {
            int buflen = len - s.length();
            char[] buf = new char[buflen];
            for (int i = 0; i < buflen; ++i) {
                buf[i] = 48;
            }
            s = new String(buf).concat(s);
        }
        return s;
    }

    /*
     * WARNING - void declaration
     */
    public static float mixedToFloat(String s) throws IllegalArgumentException {
        void var4_4;
        StringTokenizer st = new StringTokenizer(s, " /");
        try {
            switch (st.countTokens()) {
                case 1: {
                    int wholeNumber = Integer.parseInt(st.nextToken());
                    float f = wholeNumber;
                    break;
                }
                case 3: {
                    int wholeNumber = Integer.parseInt(st.nextToken());
                    int numerator = Integer.parseInt(st.nextToken());
                    int denominator = Integer.parseInt(st.nextToken());
                    float f = (float)wholeNumber + (float)numerator / (float)denominator;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(s + ": not a mixed numeral");
                }
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(s + ": not a mixed numeral");
        }
        return (float)var4_4;
    }
}

