/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.formatter;

import com.googlecode.jslint4java.Issue;
import com.googlecode.jslint4java.JSLint;
import com.googlecode.jslint4java.JSLintResult;
import com.googlecode.jslint4java.formatter.JSLintResultFormatter;
import com.googlecode.jslint4java.formatter.XmlFormatter;

public class CheckstyleXmlFormatter
extends XmlFormatter
implements JSLintResultFormatter {
    @Override
    protected String root() {
        return "checkstyle";
    }

    @Override
    public String format(JSLintResult result) {
        StringBuilder sb = new StringBuilder("<file");
        sb.append(this.attr("name", result.getName()));
        sb.append(">\n");
        for (Issue issue : result.getIssues()) {
            sb.append("<error");
            sb.append(this.attr("line", Integer.toString(issue.getLine())));
            sb.append(this.attr("column", Integer.toString(issue.getCharacter())));
            sb.append(this.attr("severity", "warning"));
            sb.append(this.attr("message", issue.getReason()));
            sb.append(this.attr("source", JSLint.class.getName()));
            sb.append("/>\n");
        }
        sb.append("</file>");
        return sb.toString();
    }
}

