/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.formatter;

public abstract class XmlFormatter {
    protected String attr(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (value == null) {
            value = "";
        }
        StringBuilder sb = new StringBuilder(32);
        sb.append(' ');
        sb.append(this.escapeAttr(key));
        sb.append("='");
        sb.append(this.escapeAttr(value));
        sb.append("'");
        return sb.toString();
    }

    protected String escape(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private String escapeAttr(String str) {
        return this.escape(str).replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }

    public String footer() {
        return "</" + this.root() + ">";
    }

    public String header() {
        return "<" + this.root() + ">";
    }

    protected abstract String root();
}

