/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yui.compressor;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class YUICompressTask
extends Task {
    private Boolean warn = Boolean.FALSE;
    private Boolean munge = Boolean.FALSE;
    private Boolean preserveAllSemiColons = Boolean.TRUE;
    private Boolean preserveStringLitterals = Boolean.TRUE;
    private Integer lineBreak = null;
    private String outputSuffix;
    private File outputFolder;
    private String charset;
    private List inputFileSet = new ArrayList();

    public void execute() throws BuildException {
        this.validate();
        Iterator iter = this.inputFileSet.iterator();
        while (iter.hasNext()) {
            FileSet fs = (FileSet)iter.next();
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File base = ds.getBasedir();
            String[] includedFiles = ds.getIncludedFiles();
            for (int i = 0; i < includedFiles.length; ++i) {
                String theFileName;
                includedFiles[i] = includedFiles[i].replace('\\', '/');
                String includePrefix = "";
                if (includedFiles[i].lastIndexOf(47) != -1) {
                    includePrefix = includedFiles[i].substring(0, includedFiles[i].lastIndexOf(47));
                }
                File found = new File(base, includedFiles[i]);
                File targetFolder = null;
                targetFolder = includePrefix.length() > 0 ? new File(this.outputFolder, includePrefix) : new File(this.outputFolder.getAbsolutePath());
                targetFolder.mkdirs();
                File outputFile = null;
                System.out.println(includedFiles[i] + ":" + targetFolder.getAbsolutePath());
                if (this.outputSuffix != null && this.outputSuffix.trim().length() != 0) {
                    theFileName = found.getName();
                    int lastIndex = theFileName.lastIndexOf(".");
                    outputFile = new File(targetFolder, theFileName.substring(0, lastIndex) + this.outputSuffix + theFileName.substring(lastIndex));
                } else {
                    theFileName = found.getName();
                    outputFile = new File(targetFolder, theFileName);
                }
                try {
                    this.doCompression(found, outputFile);
                    continue;
                }
                catch (Exception e) {
                    this.log("Error compressing " + found.getAbsolutePath() + ", " + e.getMessage(), 0);
                    throw new BuildException("Error compressing " + found.getAbsolutePath() + ", " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void validate() {
        if (this.charset == null) {
            this.charset = System.getProperty("file.encoding");
            if (this.charset == null) {
                this.charset = "UTF-8";
            }
        }
        this.munge = this.munge != null ? this.munge : Boolean.FALSE;
        this.lineBreak = this.lineBreak == null ? new Integer(-1) : this.lineBreak;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void copy(File src, File dst) throws IOException {
        IOException e22;
        FileOutputStream out;
        block12: {
            FileInputStream in = null;
            out = null;
            try {
                in = new FileInputStream(src);
                out = new FileOutputStream(dst);
                byte[] buf = new byte[1024];
                int len = 0;
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                Object var7_6 = null;
                if (in == null) break block12;
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var7_7 = null;
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                ((InputStream)in).close();
            }
            catch (IOException e22) {
                // empty catch block
            }
        }
        if (out != null) {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e22) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompression(File inputFile, File outputFile) throws Exception {
        IOException e32;
        File tempFile;
        Writer writer;
        block20: {
            this.log("Compressing " + inputFile.getAbsolutePath() + " to " + outputFile.getAbsolutePath());
            Reader reader = null;
            writer = null;
            tempFile = null;
            outputFile.getParentFile().mkdirs();
            try {
                if (inputFile.getAbsolutePath().equals(outputFile.getAbsolutePath())) {
                    this.log("Input and Output file are the same, creating a copy");
                    tempFile = File.createTempFile("temp", inputFile.getName().substring(inputFile.getName().lastIndexOf(".")));
                    this.log("Copying " + inputFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
                    YUICompressTask.copy(inputFile, tempFile);
                    reader = new BufferedReader(new FileReader(tempFile));
                } else {
                    reader = new BufferedReader(new FileReader(inputFile));
                }
                if (outputFile.getName().endsWith(".js")) {
                    try {
                        JavaScriptCompressor compressor = new JavaScriptCompressor(reader, new ErrorReporter(){

                            public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                                if (line < 0) {
                                    YUICompressTask.this.log("\n[WARNING] " + message);
                                } else {
                                    YUICompressTask.this.log("\n" + line + ':' + lineOffset + ':' + message);
                                }
                            }

                            public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                                if (line < 0) {
                                    YUICompressTask.this.log("\n[ERROR] " + message);
                                } else {
                                    YUICompressTask.this.log("\n" + line + ':' + lineOffset + ':' + message);
                                }
                            }

                            public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                                this.error(message, sourceName, line, lineSource, lineOffset);
                                return new EvaluatorException(message);
                            }
                        });
                        writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), this.charset);
                        compressor.compress(writer, this.lineBreak.intValue(), this.munge.booleanValue(), this.warn.booleanValue(), this.preserveAllSemiColons.booleanValue(), this.preserveStringLitterals.booleanValue());
                    }
                    catch (EvaluatorException e2) {
                        e2.printStackTrace();
                        System.exit(2);
                    }
                } else if (outputFile.getName().endsWith(".css")) {
                    CssCompressor compressor = new CssCompressor(reader);
                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), this.charset);
                    compressor.compress(writer, this.getLineBreak() != null ? this.getLineBreak() : -1);
                }
                Object var8_9 = null;
                if (reader == null) break block20;
            }
            catch (Throwable throwable) {
                IOException e32;
                Object var8_10 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e32) {
                        // empty catch block
                    }
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e32) {
                        // empty catch block
                    }
                }
                if (tempFile != null) {
                    tempFile.delete();
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException e32) {
                // empty catch block
            }
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e32) {
                // empty catch block
            }
        }
        if (tempFile != null) {
            tempFile.delete();
        }
    }

    private String getLine(List list) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            buffer.append(element);
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public void addFileset(FileSet fileset) {
        this.inputFileSet.add(fileset);
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public Integer getLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(Integer lineBreak) {
        this.lineBreak = lineBreak;
    }

    public Boolean getMunge() {
        return this.munge;
    }

    public void setMunge(Boolean munge) {
        this.munge = munge;
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder;
    }

    public String getOutputSuffix() {
        return this.outputSuffix;
    }

    public void setOutputSuffix(String outputSuffix) {
        this.outputSuffix = outputSuffix;
    }

    public Boolean getPreserveAllSemiColons() {
        return this.preserveAllSemiColons;
    }

    public void setPreserveAllSemiColons(Boolean preserveAllSemiColons) {
        this.preserveAllSemiColons = preserveAllSemiColons;
    }

    public Boolean getPreserveStringLitterals() {
        return this.preserveStringLitterals;
    }

    public void setPreserveStringLitterals(Boolean preserveStringLitterals) {
        this.preserveStringLitterals = preserveStringLitterals;
    }

    public Boolean getWarn() {
        return this.warn;
    }

    public void setWarn(Boolean warn) {
        this.warn = warn;
    }
}

