/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridDefRecord;
import ucar.grib.GribNumbers;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.grib.grib1.Grib1Tables;

public final class Grib1Grid
extends Grib1GridDefinitionSection {
    private static Logger log = LoggerFactory.getLogger(Grib1Grid.class);

    public Grib1Grid(Grib1ProductDefinitionSection pds) {
        int gridNumber = pds.getPdsVars().getGridId();
        this.gdskey = 1000 + gridNumber;
        switch (gridNumber) {
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                this.type = 0;
                this.name = Grib1Grid.getName(this.type);
                this.nx = 37;
                this.ny = 36;
                this.resolution = 136;
                this.dx = 5.0;
                this.dy = 2.5;
                this.grid_units = "degrees";
                this.scan = 64;
                if (gridNumber == 21) {
                    this.lat1 = 0.0;
                    this.lon1 = 0.0;
                    this.lat2 = 90.0;
                    this.lon2 = 180.0;
                    break;
                }
                if (gridNumber == 22) {
                    this.lat1 = 0.0;
                    this.lon1 = -180.0;
                    this.lat2 = 90.0;
                    this.lon2 = 0.0;
                    break;
                }
                if (gridNumber == 23) {
                    this.lat1 = -90.0;
                    this.lon1 = 0.0;
                    this.lat2 = 0.0;
                    this.lon2 = 180.0;
                    break;
                }
                if (gridNumber != 24) break;
                this.lat1 = -90.0;
                this.lon1 = -180.0;
                this.lat2 = 0.0;
                this.lon2 = 0.0;
                break;
            }
            case 25: 
            case 26: {
                this.type = 0;
                this.name = Grib1Grid.getName(this.type);
                this.nx = 72;
                this.ny = 18;
                this.resolution = 136;
                this.dx = 5.0;
                this.dy = 5.0;
                this.grid_units = "degrees";
                this.scan = 64;
                if (gridNumber == 25) {
                    this.lat1 = 0.0;
                    this.lon1 = 0.0;
                    this.lat2 = 90.0;
                    this.lon2 = 355.0;
                    break;
                }
                if (gridNumber != 26) break;
                this.lat1 = -90.0;
                this.lon1 = 0.0;
                this.lat2 = 0.0;
                this.lon2 = 355.0;
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                this.type = 0;
                this.name = Grib1Grid.getName(this.type);
                this.nx = 91;
                this.ny = 45;
                this.resolution = 136;
                this.dx = 2.0;
                this.dy = 2.0;
                this.grid_units = "degrees";
                this.scan = 64;
                if (gridNumber == 61) {
                    this.lat1 = 0.0;
                    this.lon1 = 0.0;
                    this.lat2 = 90.0;
                    this.lon2 = 180.0;
                    break;
                }
                if (gridNumber == 62) {
                    this.lat1 = 0.0;
                    this.lon1 = -180.0;
                    this.lat2 = 90.0;
                    this.lon2 = 0.0;
                    break;
                }
                if (gridNumber == 63) {
                    this.lat1 = -90.0;
                    this.lon1 = 0.0;
                    this.lat2 = 0.0;
                    this.lon2 = 180.0;
                    break;
                }
                if (gridNumber != 64) break;
                this.lat1 = -90.0;
                this.lon1 = -180.0;
                this.lat2 = 0.0;
                this.lon2 = 0.0;
                break;
            }
            case 87: {
                this.type = 5;
                this.name = Grib1Grid.getName(this.type);
                this.nx = 81;
                this.ny = 62;
                this.lat1 = 22.8756;
                this.lon1 = 239.5089;
                this.resolution = 8;
                this.lov = 255.0;
                this.lat2 = 0.0;
                this.dx = 68153.0;
                this.dy = 68153.0;
                this.grid_units = "m";
                this.scan = 64;
                break;
            }
            default: {
                System.out.println("Grid " + gridNumber + " not configured yet");
            }
        }
    }

    public static void printGDS(int gdsKey) {
        int gridNumber = gdsKey - 1000;
        System.out.println("GDSkey = " + Integer.toString(gdsKey));
        int gdtn = -1;
        int resolution = 0;
        int shape = 0;
        switch (gridNumber) {
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                gdtn = 0;
                System.out.println("grid_type = " + gdtn);
                System.out.println("grid_name = " + Grib1Tables.getGridName(gdtn));
                System.out.println("Nx = 37");
                System.out.println("Ny = 36");
                resolution = 136;
                System.out.println("ResCompFlag = " + resolution);
                System.out.println("Dx = 5.0");
                System.out.println("Dy = 2.5");
                System.out.println("grid_units = degrees");
                if (gridNumber == 21) {
                    System.out.println("La1 = 0.0");
                    System.out.println("Lo1 = 0.0");
                    System.out.println("La2 = 90.0");
                    System.out.println("Lo2 = 180.0");
                    break;
                }
                if (gridNumber == 22) {
                    System.out.println("La1 = 0.0");
                    System.out.println("Lo1 = -180.0");
                    System.out.println("La2 = 90.0");
                    System.out.println("Lo2 = 0.0");
                    break;
                }
                if (gridNumber == 23) {
                    System.out.println("La1 = -90.0");
                    System.out.println("Lo1 = 0.0");
                    System.out.println("La2 = 0.0");
                    System.out.println("Lo2 = 180.0");
                    break;
                }
                if (gridNumber != 24) break;
                System.out.println("La1 = -90.0");
                System.out.println("Lo1 = -180.0");
                System.out.println("La2 = 0.0");
                System.out.println("Lo2 = 0.0");
                break;
            }
            case 25: 
            case 26: {
                gdtn = 0;
                System.out.println("grid_type = " + gdtn);
                System.out.println("grid_name = " + Grib1Tables.getGridName(gdtn));
                System.out.println("Nx = 72");
                System.out.println("Ny = 18");
                resolution = 136;
                System.out.println("ResCompFlag = " + resolution);
                System.out.println("Dx = 5.0");
                System.out.println("Dy = 5.0");
                System.out.println("grid_units = degrees");
                if (gridNumber == 25) {
                    System.out.println("La1 = 0.0");
                    System.out.println("Lo1 = 0.0");
                    System.out.println("La2 = 0.0");
                    System.out.println("Lo2 = 355.0");
                    break;
                }
                if (gridNumber != 26) break;
                System.out.println("La1 = -90.0");
                System.out.println("Lo1 = 0.0");
                System.out.println("La2 = 0.0");
                System.out.println("Lo2 = 355.0");
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                gdtn = 0;
                System.out.println("grid_type = " + gdtn);
                System.out.println("grid_name = " + Grib1Tables.getGridName(gdtn));
                System.out.println("Nx = 91");
                System.out.println("Ny = 45");
                resolution = 136;
                System.out.println("ResCompFlag = " + resolution);
                System.out.println("Dx = 2.0");
                System.out.println("Dy = 2.0");
                System.out.println("grid_units = degrees");
                if (gridNumber == 61) {
                    System.out.println("La1 = 0.0");
                    System.out.println("Lo1 = 0.0");
                    System.out.println("La2 = 90.0");
                    System.out.println("Lo2 = 180.0");
                    break;
                }
                if (gridNumber == 62) {
                    System.out.println("La1 = 0.0");
                    System.out.println("Lo1 = -180.0");
                    System.out.println("La2 = 90.0");
                    System.out.println("Lo2 = 0.0");
                    break;
                }
                if (gridNumber == 63) {
                    System.out.println("La1 = -90.0");
                    System.out.println("Lo1 = 0.0");
                    System.out.println("La2 = 0.0");
                    System.out.println("Lo2 = 180.0");
                    break;
                }
                if (gridNumber != 64) break;
                System.out.println("La1 = -90.0");
                System.out.println("Lo1 = -180.0");
                System.out.println("La2 = 0.0");
                System.out.println("Lo2 = 0.0");
                break;
            }
            case 87: {
                gdtn = 5;
                System.out.println("grid_type = " + gdtn);
                System.out.println("grid_name = " + Grib1Tables.getGridName(gdtn));
                System.out.println("Nx = 81");
                System.out.println("Ny = 62");
                System.out.println("La1 = 22.8756");
                System.out.println("Lo1 = 239.5089");
                resolution = 8;
                System.out.println("ResCompFlag = " + resolution);
                System.out.println("LoV = 255.0");
                System.out.println("La2 = 0.0");
                System.out.println("Dx = 68153.0");
                System.out.println("Dy = 68153.0");
                System.out.println("grid_units = m");
                break;
            }
            default: {
                log.error("Grid " + gridNumber + " not configured yet");
            }
        }
        String winds = GribNumbers.isBitSet(resolution, 8) ? "Relative" : "True";
        System.out.println("Winds = " + winds);
        int res = resolution >> 6;
        shape = res == 1 || res == 3 ? 1 : 0;
        System.out.println("grid_shape_code = " + shape);
        System.out.println("grid_shape = " + Grib1Tables.getShapeName(shape));
        if (shape == 0) {
            System.out.println("grid_radius_spherical_earth = 6367.47");
        } else {
            System.out.println("grid_major_axis_earth = 6378.16");
            System.out.println("grid_minor_axis_earth = 6356.775");
        }
    }

    public static void populateGDS(GribGridDefRecord ggdr, int gdsKey) {
        int gridNumber = gdsKey - 1000;
        ggdr.addParam("GDSkey", Integer.toString(gdsKey));
        int gdtn = -1;
        int resolution = 0;
        int shape = 0;
        switch (gridNumber) {
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                gdtn = 0;
                ggdr.addParam("grid_type", gdtn);
                ggdr.addParam("grid_name", Grib1Tables.getGridName(gdtn));
                ggdr.addParam("Nx", 37);
                ggdr.addParam("Ny", 36);
                resolution = 136;
                ggdr.addParam("ResCompFlag", resolution);
                ggdr.addParam("Dx", 5.0);
                ggdr.addParam("Dy", 2.5);
                ggdr.addParam("grid_units", "degrees");
                if (gridNumber == 21) {
                    ggdr.addParam("La1", 0.0);
                    ggdr.addParam("Lo1", 0.0);
                    ggdr.addParam("La2", 90.0);
                    ggdr.addParam("Lo2", 180.0);
                    break;
                }
                if (gridNumber == 22) {
                    ggdr.addParam("La1", 0.0);
                    ggdr.addParam("Lo1", -180.0);
                    ggdr.addParam("La2", 90.0);
                    ggdr.addParam("Lo2", 0.0);
                    break;
                }
                if (gridNumber == 23) {
                    ggdr.addParam("La1", -90.0);
                    ggdr.addParam("Lo1", 0.0);
                    ggdr.addParam("La2", 0.0);
                    ggdr.addParam("Lo2", 180.0);
                    break;
                }
                if (gridNumber != 24) break;
                ggdr.addParam("La1", -90.0);
                ggdr.addParam("Lo1", -180.0);
                ggdr.addParam("La2", 0.0);
                ggdr.addParam("Lo2", 0.0);
                break;
            }
            case 25: 
            case 26: {
                gdtn = 0;
                ggdr.addParam("grid_type", gdtn);
                ggdr.addParam("grid_name", Grib1Tables.getGridName(gdtn));
                ggdr.addParam("Nx", 72);
                ggdr.addParam("Ny", 18);
                resolution = 136;
                ggdr.addParam("ResCompFlag", resolution);
                ggdr.addParam("Dx", 5.0);
                ggdr.addParam("Dy", 5.0);
                ggdr.addParam("grid_units", "degrees");
                if (gridNumber == 25) {
                    ggdr.addParam("La1", 0.0);
                    ggdr.addParam("Lo1", 0.0);
                    ggdr.addParam("La2", 0.0);
                    ggdr.addParam("Lo2", 355.0);
                    break;
                }
                if (gridNumber != 26) break;
                ggdr.addParam("La1", -90.0);
                ggdr.addParam("Lo1", 0.0);
                ggdr.addParam("La2", 0.0);
                ggdr.addParam("Lo2", 355.0);
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                gdtn = 0;
                ggdr.addParam("grid_type", gdtn);
                ggdr.addParam("grid_name", Grib1Tables.getGridName(gdtn));
                ggdr.addParam("Nx", 91);
                ggdr.addParam("Ny", 45);
                resolution = 136;
                ggdr.addParam("ResCompFlag", resolution);
                ggdr.addParam("Dx", 2.0);
                ggdr.addParam("Dy", 2.0);
                ggdr.addParam("grid_units", "degrees");
                if (gridNumber == 61) {
                    ggdr.addParam("La1", 0.0);
                    ggdr.addParam("Lo1", 0.0);
                    ggdr.addParam("La2", 90.0);
                    ggdr.addParam("Lo2", 180.0);
                    break;
                }
                if (gridNumber == 62) {
                    ggdr.addParam("La1", 0.0);
                    ggdr.addParam("Lo1", -180.0);
                    ggdr.addParam("La2", 90.0);
                    ggdr.addParam("Lo2", 0.0);
                    break;
                }
                if (gridNumber == 63) {
                    ggdr.addParam("La1", -90.0);
                    ggdr.addParam("Lo1", 0.0);
                    ggdr.addParam("La2", 0.0);
                    ggdr.addParam("Lo2", 180.0);
                    break;
                }
                if (gridNumber != 64) break;
                ggdr.addParam("La1", -90.0);
                ggdr.addParam("Lo1", -180.0);
                ggdr.addParam("La2", 0.0);
                ggdr.addParam("Lo2", 0.0);
                break;
            }
            case 87: {
                gdtn = 5;
                ggdr.addParam("grid_type", gdtn);
                ggdr.addParam("grid_name", Grib1Tables.getGridName(gdtn));
                ggdr.addParam("Nx", 81);
                ggdr.addParam("Ny", 62);
                ggdr.addParam("La1", 22.8756);
                ggdr.addParam("Lo1", 239.5089);
                resolution = 8;
                ggdr.addParam("ResCompFlag", resolution);
                ggdr.addParam("LoV", 255.0);
                ggdr.addParam("La2", 0.0);
                ggdr.addParam("Dx", 68153.0);
                ggdr.addParam("Dy", 68153.0);
                ggdr.addParam("grid_units", "m");
                break;
            }
            default: {
                log.error("Grid " + gridNumber + " not configured yet");
            }
        }
        String winds = GribNumbers.isBitSet(resolution, 8) ? "Relative" : "True";
        ggdr.addParam("Winds", winds);
        int res = resolution >> 6;
        shape = res == 1 || res == 3 ? 1 : 0;
        ggdr.addParam("grid_shape_code", shape);
        ggdr.addParam("grid_shape", Grib1Tables.getShapeName(shape));
        if (shape == 0) {
            ggdr.addParam("grid_radius_spherical_earth", 6367.47);
        } else {
            ggdr.addParam("grid_major_axis_earth", 6378.16);
            ggdr.addParam("grid_minor_axis_earth", 6356.775);
        }
    }
}

