/*
 * Decompiled with CFR 0.152.
 */
package org.hansel;

import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.hansel.ProbeTable;
import org.hansel.Startup;
import org.hansel.probes.ProbeFilter;

public class CoverageDecorator
extends TestSuite {
    private String[] classNamesCovered;
    private Class[] classesCovered;
    private ProbeTable probeTable;

    public CoverageDecorator(Class[] classesCovered) {
        this(classesCovered, null);
    }

    public CoverageDecorator(Class[] classesCovered, ProbeFilter probeFilter) {
        this.patchTestClassLoader();
        this.classesCovered = classesCovered;
        this.classNamesCovered = new String[classesCovered.length];
        for (int i = 0; i < this.classNamesCovered.length; ++i) {
            this.classNamesCovered[i] = classesCovered[i].getName();
        }
        this.probeTable = new ProbeTable(probeFilter);
    }

    private void patchTestClassLoader() {
    }

    public CoverageDecorator(Class testClass, Class[] classesCovered) {
        this(classesCovered);
        this.addTestSuite(testClass);
    }

    public CoverageDecorator(Class testClass, Class[] classesCovered, ProbeFilter probeFilter) {
        this(classesCovered, probeFilter);
        this.addTestSuite(testClass);
    }

    public void setDisplayStatistics(boolean display) {
        this.probeTable.setDisplayStatistics(display);
    }

    public Class[] getClassesCovered() {
        return this.classesCovered;
    }

    protected ProbeTable getProbeTable() {
        return this.probeTable;
    }

    protected void superRun(TestResult result) {
        super.run(result);
    }

    protected boolean init(TestResult result) {
        ProbeTable.setProbeTable(this.probeTable);
        try {
            Startup.init(new HashSet<String>(Arrays.asList(this.classNamesCovered)));
        }
        catch (Exception e) {
            result.addError((Test)this, (Throwable)e);
            return false;
        }
        return true;
    }

    protected void shutdown(TestResult result) {
        try {
            this.loadClasses();
            Startup.tearDown();
            this.probeTable.run(result);
        }
        catch (Exception e) {
            result.addError((Test)this, (Throwable)e);
        }
    }

    public void run(TestResult result) {
        if (!this.init(result)) {
            return;
        }
        super.run(result);
        this.shutdown(result);
    }

    private void loadClasses() {
        for (int i = 0; i < this.classesCovered.length; ++i) {
            this.classesCovered[i].getDeclaredFields();
        }
    }

    public String toString() {
        return "Coverage Decorator";
    }
}

