/*
 * Decompiled with CFR 0.152.
 */
package org.hansel;

import java.util.List;
import org.hansel.stack.BinaryOperatorEntry;
import org.hansel.stack.HanselValue;
import org.hansel.stack.PrefixOpEntry;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.objectweb.asm.tree.analysis.Value;

public final class HanselInterpreter
extends SourceInterpreter {
    private static final int PRECEDENCE_CAST = 1;
    private static final int PRECEDENCE_UNARY_MINUS = 1;
    private static final int PRECEDENCE_MUL = 2;
    private static final int PRECEDENCE_ADD = 3;
    private static final int PRECEDENCE_SHIFT = 4;
    private static final int PRECEDENCE_INSTANCEOF = 5;
    private static final int PRECEDENCE_COMPARE = 5;
    private static final int PRECEDENCE_AND = 7;
    private static final int PRECEDENCE_XOR = 8;
    private static final int PRECEDENCE_OR = 9;
    private List localVariables;

    public HanselInterpreter(List localVariables) {
        this.localVariables = localVariables;
    }

    public Value binaryOperation(AbstractInsnNode insn, Value value1, Value value2) {
        switch (insn.getOpcode()) {
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 181: {
                return null;
            }
            case 47: 
            case 49: {
                return new HanselValue(value1 + "[" + value2 + "]", false, 2);
            }
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 53: {
                return new HanselValue(value1 + "[" + value2 + "]", false, 1);
            }
            case 51: {
                return new HanselValue(value1 + "[" + value2 + "]", true, 1);
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                return new BinaryOperatorEntry("+", 3, value1, value2);
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return new BinaryOperatorEntry("-", 3, value1, value2);
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return new BinaryOperatorEntry("*", 2, value1, value2);
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return new BinaryOperatorEntry("/", 2, value1, value2);
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                return new BinaryOperatorEntry("%", 2, value1, value2);
            }
            case 120: 
            case 121: {
                return new BinaryOperatorEntry("<<", 4, value1, value2);
            }
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                return new BinaryOperatorEntry(">>", 4, value1, value2);
            }
            case 126: 
            case 127: {
                return new BinaryOperatorEntry("&", 7, value1, value2);
            }
            case 128: 
            case 129: {
                return new BinaryOperatorEntry("|", 9, value1, value2);
            }
            case 130: 
            case 131: {
                return new BinaryOperatorEntry("^", 8, value1, value2);
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return new BinaryOperatorEntry("<", 5, value1, value2, 1);
            }
        }
        throw this.failure(insn);
    }

    private HanselValue findLocalVar(int index, AbstractInsnNode insn) {
        for (LocalVariableNode lvn : this.localVariables) {
            if (lvn.index != index) continue;
            return new HanselValue(lvn.name, this.isBool(lvn.desc), this.getSize(lvn.desc));
        }
        return new HanselValue("Unknown local: " + index, false, 1);
    }

    private int getSize(String desc) {
        return Type.getType((String)desc).getSize();
    }

    private boolean isBool(String desc) {
        return this.isBool(Type.getType((String)desc));
    }

    private boolean isBool(Type type) {
        return type.equals((Object)Type.BOOLEAN_TYPE);
    }

    public Value copyOperation(AbstractInsnNode insn, Value value) {
        if (insn instanceof VarInsnNode) {
            return this.findLocalVar(((VarInsnNode)insn).var, insn);
        }
        switch (insn.getOpcode()) {
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                return value;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return HanselValue.DONT_CARE;
            }
        }
        throw this.failure(insn);
    }

    public Value merge(Value v, Value w) {
        return v;
    }

    private HanselValue multiANewArray(MultiANewArrayInsnNode node, List values) {
        String result = node.desc;
        for (int i = 0; i < values.size(); ++i) {
            result = result + "[" + values.get(i) + "]";
        }
        return new HanselValue(result, false, 1);
    }

    private HanselValue invokeMethod(MethodInsnNode node, List values) {
        String result = "";
        int start = 0;
        if (node.getOpcode() != 184) {
            start = 1;
            result = values.get(0) + ".";
        }
        result = result + node.name + "(";
        for (int i = start; i < values.size(); ++i) {
            result = result + values.get(i);
            if (i == values.size() - 1) continue;
            result = result + ", ";
        }
        return new HanselValue(result + ")", this.isBool(Type.getReturnType((String)node.desc)), Type.getReturnType((String)node.desc).getSize());
    }

    public Value naryOperation(AbstractInsnNode insn, List values) {
        switch (insn.getOpcode()) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                return this.invokeMethod((MethodInsnNode)insn, values);
            }
            case 197: {
                return this.multiANewArray((MultiANewArrayInsnNode)insn, values);
            }
        }
        throw this.failure(insn);
    }

    private IllegalStateException failure(AbstractInsnNode insn) {
        Thread.dumpStack();
        return new IllegalStateException("Unknown instruction: " + insn.getOpcode() + " " + insn + " (Class: " + insn.getClass() + ")");
    }

    public Value newOperation(AbstractInsnNode insn) {
        switch (insn.getOpcode()) {
            case 1: {
                return HanselValue.NULL;
            }
            case 9: {
                return HanselValue.ZERO_2;
            }
            case 10: {
                return HanselValue.ONE_2;
            }
            case 11: {
                return HanselValue.ZERO_1;
            }
            case 12: {
                return HanselValue.ONE_1;
            }
            case 13: {
                return new HanselValue("2", false, 1);
            }
            case 14: {
                return HanselValue.ZERO_2;
            }
            case 15: {
                return HanselValue.ONE_1;
            }
            case 2: {
                return new HanselValue("-1", false, 1);
            }
            case 3: {
                return HanselValue.ZERO_1;
            }
            case 4: {
                return HanselValue.ONE_1;
            }
            case 5: {
                return new HanselValue("2", false, 1);
            }
            case 6: {
                return new HanselValue("3", false, 1);
            }
            case 7: {
                return new HanselValue("4", false, 1);
            }
            case 8: {
                return new HanselValue("5", false, 1);
            }
            case 16: 
            case 17: {
                return new HanselValue(String.valueOf(((IntInsnNode)insn).operand), false, 1);
            }
            case 18: {
                return this.formatLDC(((LdcInsnNode)insn).cst);
            }
            case 178: {
                return new HanselValue(((FieldInsnNode)insn).name, this.isBool(((FieldInsnNode)insn).desc), this.getSize(((FieldInsnNode)insn).desc));
            }
            case 168: {
                return HanselValue.DONT_CARE;
            }
            case 187: {
                return new HanselValue("new " + ((TypeInsnNode)insn).desc + "()", false, 1);
            }
        }
        throw this.failure(insn);
    }

    private HanselValue formatLDC(Object cst) {
        String result;
        Type t;
        if (cst instanceof Type && (t = (Type)cst).getSort() == 10 && (result = t.getClassName()).indexOf(46) > -1) {
            return new HanselValue(result.substring(result.lastIndexOf(46) + 1) + ".class", false, 1);
        }
        if (cst instanceof Double || cst instanceof Long) {
            return new HanselValue(cst.toString(), false, 2);
        }
        if (cst instanceof String) {
            return new HanselValue("\"" + cst.toString() + "\"", false, 1);
        }
        return new HanselValue(cst.toString(), false, 1);
    }

    public Value newValue(Type type) {
        return HanselValue.DONT_CARE;
    }

    public Value ternaryOperation(AbstractInsnNode insn, Value value1, Value value2, Value value3) {
        switch (insn.getOpcode()) {
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                return HanselValue.DONT_CARE;
            }
        }
        throw this.failure(insn);
    }

    public Value unaryOperation(AbstractInsnNode insn, Value value) {
        switch (insn.getOpcode()) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 179: 
            case 191: 
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                return null;
            }
            case 132: {
                return HanselValue.DONT_CARE;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                return new PrefixOpEntry("-", 1, (HanselValue)value);
            }
            case 133: 
            case 140: 
            case 143: {
                return new PrefixOpEntry("(long)", 1, (HanselValue)value, 2);
            }
            case 134: 
            case 137: 
            case 144: {
                return new PrefixOpEntry("(float)", 1, (HanselValue)value, 1);
            }
            case 135: 
            case 138: 
            case 141: {
                return new PrefixOpEntry("(double)", 1, (HanselValue)value, 2);
            }
            case 136: 
            case 139: 
            case 142: {
                return new PrefixOpEntry("(int)", 1, (HanselValue)value, 1);
            }
            case 145: {
                return new PrefixOpEntry("(boolean)", 1, (HanselValue)value, 1);
            }
            case 146: {
                return new PrefixOpEntry("(char)", 1, (HanselValue)value, 1);
            }
            case 147: {
                return new PrefixOpEntry("(short)", 1, (HanselValue)value, 1);
            }
            case 193: {
                return new BinaryOperatorEntry("instanceof", 5, (HanselValue)value, new HanselValue(((TypeInsnNode)insn).desc, false, 1), 1);
            }
            case 188: {
                return new HanselValue("new " + this.getType(((IntInsnNode)insn).operand) + "[" + value + "]", false, 1);
            }
            case 189: {
                return new HanselValue("new " + ((TypeInsnNode)insn).desc + "[" + value + "]", false, 1);
            }
            case 190: {
                return new HanselValue(value + ".length", false, 1);
            }
            case 192: {
                return new PrefixOpEntry("(" + ((TypeInsnNode)insn).desc + ")", 1, (HanselValue)value, 1);
            }
            case 180: {
                return new HanselValue("this." + ((FieldInsnNode)insn).name, this.isBool(((FieldInsnNode)insn).desc), this.getSize(((FieldInsnNode)insn).desc));
            }
        }
        throw this.failure(insn);
    }

    private String getType(int operand) {
        switch (operand) {
            case 4: {
                return "boolean";
            }
            case 5: {
                return "char";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 8: {
                return "byte";
            }
            case 9: {
                return "short";
            }
            case 10: {
                return "int";
            }
            case 11: {
                return "long";
            }
        }
        throw new IllegalArgumentException("Unknown type of newarray: " + operand);
    }
}

