/*
 * Decompiled with CFR 0.152.
 */
package org.hansel;

import java.io.PrintStream;
import java.io.PrintWriter;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestResult;
import org.hansel.ProbeData;
import org.hansel.ProbeTable;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.objectweb.asm.MethodVisitor;

public abstract class Probe
implements Test {
    public static final String HIT_CLASS = ProbeTable.class.getName().replace('.', '/');
    private ProbeData pd;
    private int id;
    private Description description;

    public Probe(ProbeData pd) {
        this.pd = pd;
        this.id = ProbeTable.getProbeTable().addProbe(this);
    }

    public abstract String getFailureMessage();

    public abstract boolean displayFailure();

    public abstract boolean coverageFailure();

    public abstract void insertProbeCode(MethodVisitor var1);

    public ProbeData getProbeData() {
        return this.pd;
    }

    public int getID() {
        return this.id;
    }

    public void addResult(Test test, TestResult result) {
    }

    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Probe p = (Probe)o;
        return this.pd.equals(p.pd);
    }

    public int hashCode() {
        return this.pd.hashCode();
    }

    public String toString() {
        return "Probe in \"" + this.pd.getShortClassName() + ".java\" line " + this.pd.getLineNumber();
    }

    public int countTestCases() {
        return 1;
    }

    public void run(TestResult result) {
        result.startTest((Test)this);
        if (this.displayFailure()) {
            result.addFailure((Test)this, (AssertionFailedError)new CoverageError(this.pd));
        }
        result.endTest((Test)this);
    }

    public void run(RunNotifier result, Description coverageDescription) throws ClassNotFoundException {
        result.fireTestStarted(this.getDescription());
        if (this.displayFailure()) {
            result.fireTestFailure(new Failure(this.getDescription(), (Throwable)((Object)new CoverageError(this.pd))));
        }
        result.fireTestFinished(this.getDescription());
    }

    public String getName() {
        return this.pd.getShortClassName() + ":" + this.pd.getLineNumber();
    }

    public Description getDescription() throws ClassNotFoundException {
        if (this.description == null) {
            this.description = Description.createTestDescription((Class)this.pd.getTargetClass(), (String)this.getName());
        }
        return this.description;
    }

    private class CoverageError
    extends AssertionFailedError {
        private static final long serialVersionUID = 1L;
        private ProbeData pd;

        public CoverageError(ProbeData pd) {
            super(" Coverage failure: " + Probe.this.getFailureMessage());
            this.pd = pd;
        }

        public void printStackTrace() {
            this.printStackTrace(System.err);
        }

        public void printStackTrace(PrintStream s) {
            this.printStackTrace(new PrintWriter(s, true));
        }

        public void printStackTrace(PrintWriter s) {
            s.println(this.getMessage());
            s.println("  at " + this.pd.getClassName() + "." + this.pd.getMethodName() + "(" + this.pd.getShortClassName() + ".java:" + this.pd.getLineNumber() + ")");
        }
    }
}

