/*
 * Decompiled with CFR 0.152.
 */
package org.hansel;

import org.hansel.HanselFrame;
import org.hansel.stack.HanselValue;

public class ProbeData {
    private String classname;
    private String methodname;
    private int lineNumber;
    private int pos;
    private int size;
    private HanselFrame frame;
    private ClassLoader loader;

    public ProbeData(String classname, String methodname, HanselFrame frame, int pos, int size, ClassLoader loader) {
        this.classname = classname;
        this.methodname = methodname;
        this.pos = pos;
        this.size = size;
        this.frame = frame;
        this.loader = loader;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getClassName() {
        return this.classname.replace('/', '.');
    }

    public String getShortClassName() {
        String result = this.classname;
        if (result.indexOf("/") > -1) {
            result = result.substring(result.lastIndexOf("/") + 1);
        }
        if (result.indexOf("$") > -1) {
            result = result.substring(0, result.lastIndexOf("$"));
        }
        return result;
    }

    public String getMethodName() {
        return this.methodname;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getStackSize() {
        if (this.frame != null) {
            return this.frame.getStackSize();
        }
        return -1;
    }

    public HanselValue getStackEntry(int depth) {
        if (this.frame != null) {
            return (HanselValue)this.frame.getStack(depth);
        }
        return new HanselValue("<unknown>", false, 1);
    }

    public int getPosition() {
        return this.pos;
    }

    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ProbeData pd = (ProbeData)o;
        return this.classname.equals(pd.classname) && this.methodname.equals(pd.methodname) && this.pos == pd.pos && this.size == pd.size;
    }

    public int hashCode() {
        return this.classname.hashCode() ^ this.methodname.hashCode() ^ this.pos << 16 ^ this.size;
    }

    public Class getTargetClass() throws ClassNotFoundException {
        return this.loader.loadClass(this.getClassName());
    }
}

