/*
 * Decompiled with CFR 0.152.
 */
package org.hansel;

import java.lang.reflect.Constructor;
import org.hansel.Probe;
import org.hansel.ProbeData;
import org.hansel.ProbeTable;
import org.hansel.probes.ACmpBranchProbe;
import org.hansel.probes.BinaryBranchProbe;
import org.hansel.probes.BranchProbe;
import org.hansel.probes.EQComparator;
import org.hansel.probes.ExceptionProbe;
import org.hansel.probes.GEComparator;
import org.hansel.probes.GTComparator;
import org.hansel.probes.IntComparator;
import org.hansel.probes.LEComparator;
import org.hansel.probes.LTComparator;
import org.hansel.probes.MethodProbe;
import org.hansel.probes.NEComparator;
import org.hansel.probes.NullCmpBranchProbe;
import org.hansel.probes.SelectProbe;
import org.hansel.probes.UnaryBranchProbe;
import org.objectweb.asm.Label;

public class ProbeFactory {
    private static final Class[] BRANCH_CLASS_ARGS = new Class[]{ProbeData.class, IntComparator.class};
    private static final BranchClassEntry[] BRANCH_CLASSES = new BranchClassEntry[]{new BranchClassEntry(153, UnaryBranchProbe.class, new EQComparator()), new BranchClassEntry(154, UnaryBranchProbe.class, new NEComparator()), new BranchClassEntry(156, UnaryBranchProbe.class, new GEComparator()), new BranchClassEntry(157, UnaryBranchProbe.class, new GTComparator()), new BranchClassEntry(158, UnaryBranchProbe.class, new LEComparator()), new BranchClassEntry(155, UnaryBranchProbe.class, new LTComparator()), new BranchClassEntry(159, BinaryBranchProbe.class, new EQComparator()), new BranchClassEntry(160, BinaryBranchProbe.class, new NEComparator()), new BranchClassEntry(162, BinaryBranchProbe.class, new GEComparator()), new BranchClassEntry(163, BinaryBranchProbe.class, new GTComparator()), new BranchClassEntry(164, BinaryBranchProbe.class, new LEComparator()), new BranchClassEntry(161, BinaryBranchProbe.class, new LTComparator())};

    public static MethodProbe createMethodProbe(ProbeData pd) {
        MethodProbe cached = (MethodProbe)ProbeTable.getProbeTable().getCached(pd);
        if (cached != null) {
            return cached;
        }
        return new MethodProbe(pd);
    }

    public static ExceptionProbe createExceptionProbe(ProbeData pd, Probe mp) {
        ExceptionProbe cached = (ExceptionProbe)ProbeTable.getProbeTable().getCached(pd);
        if (cached != null) {
            return cached;
        }
        return new ExceptionProbe(mp, pd);
    }

    public static SelectProbe createSelectProbe(ProbeData pd, Label dflt, int[] keys, Label[] labels) {
        SelectProbe cached = (SelectProbe)ProbeTable.getProbeTable().getCached(pd);
        if (cached != null) {
            return cached;
        }
        return new SelectProbe(pd, dflt, keys, labels);
    }

    public static SelectProbe createSelectProbe(ProbeData pd, int min, int max, Label dflt, Label[] labels) {
        SelectProbe cached = (SelectProbe)ProbeTable.getProbeTable().getCached(pd);
        if (cached != null) {
            return cached;
        }
        return new SelectProbe(pd, min, max, dflt, labels);
    }

    public static BranchProbe createBranchProbe(ProbeData pd, int opcode) {
        BranchProbe cached = (BranchProbe)ProbeTable.getProbeTable().getCached(pd);
        if (cached != null) {
            return cached;
        }
        for (int i = 0; i < BRANCH_CLASSES.length; ++i) {
            if (opcode != BRANCH_CLASSES[i].getBranchOpcode()) continue;
            return BRANCH_CLASSES[i].createProbe(pd);
        }
        if (opcode == 165) {
            return new ACmpBranchProbe(pd, true);
        }
        if (opcode == 166) {
            return new ACmpBranchProbe(pd, false);
        }
        if (opcode == 199) {
            return new NullCmpBranchProbe(pd, false);
        }
        if (opcode == 198) {
            return new NullCmpBranchProbe(pd, true);
        }
        throw new UnsupportedOperationException("Unknown branch opcode:" + opcode);
    }

    private static class BranchClassEntry {
        private int opcode;
        private Class probeClazz;
        private IntComparator cmp;

        public BranchClassEntry(int opcode, Class probeClazz, IntComparator cmp) {
            this.opcode = opcode;
            this.probeClazz = probeClazz;
            this.cmp = cmp;
        }

        public int getBranchOpcode() {
            return this.opcode;
        }

        public BranchProbe createProbe(ProbeData pd) {
            try {
                Constructor constr = this.probeClazz.getConstructor(BRANCH_CLASS_ARGS);
                return (BranchProbe)constr.newInstance(pd, this.cmp);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

