/*
 * Decompiled with CFR 0.152.
 */
package org.hansel;

import org.hansel.HanselCodeAdapter;
import org.hansel.HanselFrame;
import org.hansel.HanselInterpreter;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;

public class TransformingAdapter
extends ClassAdapter {
    private ClassNode classNode;
    private ClassLoader loader;

    public TransformingAdapter(ClassVisitor cv, ClassNode classNode, ClassLoader loader) {
        super(cv);
        this.classNode = classNode;
        this.loader = loader;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
    }

    private MethodNode getMethodNode(String name, String desc) {
        for (int i = 0; i < this.classNode.methods.size(); ++i) {
            MethodNode mn = (MethodNode)this.classNode.methods.get(i);
            if (!mn.name.equals(name) || !mn.desc.equals(desc)) continue;
            return mn;
        }
        throw new IllegalStateException("Method: " + name + " - " + desc + " not found.");
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        try {
            MethodNode mn = this.getMethodNode(name, desc);
            if ((mn.access & 0x400) != 0) {
                return this.cv.visitMethod(access, name, desc, signature, exceptions);
            }
            if (this.isPrivateEmptyConstructor(name, access, mn.instructions) || this.isSynthetic(access)) {
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
            Analyzer analyzer = new Analyzer((Interpreter)new HanselInterpreter(mn.localVariables)){

                protected Frame newFrame(int nLocals, int nStack) {
                    return new HanselFrame(nLocals, nStack);
                }

                protected Frame newFrame(Frame src) {
                    return new HanselFrame((HanselFrame)src);
                }
            };
            Frame[] frames = analyzer.analyze(this.classNode.name, mn);
            HanselFrame[] hanselFrames = new HanselFrame[frames.length];
            for (int i = 0; i < frames.length; ++i) {
                hanselFrames[i] = (HanselFrame)frames[i];
            }
            return new HanselCodeAdapter(access, this.classNode.name, mn.name, mn.instructions, mn.tryCatchBlocks, this.cv.visitMethod(access, name, desc, signature, exceptions), hanselFrames, this.loader);
        }
        catch (AnalyzerException e) {
            e.printStackTrace();
            throw new IllegalStateException(this.classNode.name + "." + name, e);
        }
    }

    private boolean isSynthetic(int access) {
        return (access & 0x1000) != 0;
    }

    private boolean isPrivateEmptyConstructor(String name, int access, InsnList instructions) {
        return (access & 2) != 0 && "<init>".equals(name) && instructions.size() == 6;
    }
}

