/*
 * Decompiled with CFR 0.152.
 */
package org.hansel.probes;

import org.hansel.ProbeData;
import org.hansel.probes.BranchProbe;
import org.hansel.probes.EQComparator;
import org.hansel.probes.IntComparator;
import org.hansel.probes.NEComparator;
import org.hansel.stack.BinaryOperatorEntry;
import org.hansel.stack.HanselValue;
import org.hansel.stack.NotOp;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.analysis.AnalyzerException;

public class UnaryBranchProbe
extends BranchProbe {
    private IntComparator cmp;

    public UnaryBranchProbe(ProbeData pd, IntComparator cmp) throws AnalyzerException {
        super(pd, UnaryBranchProbe.getStackEntry(cmp, pd.getStackEntry(0)));
        this.cmp = cmp;
    }

    private static HanselValue getStackEntry(IntComparator cmp, HanselValue op) {
        if (!op.isBoolType()) {
            HanselValue value = op.getSize() == 1 ? HanselValue.ZERO_1 : HanselValue.ZERO_2;
            return new BinaryOperatorEntry(cmp.getSign(), cmp.getPrecedence(), op, value);
        }
        if (cmp instanceof EQComparator) {
            return new NotOp(op);
        }
        if (cmp instanceof NEComparator) {
            return op;
        }
        throw new IllegalStateException();
    }

    public void hit(int value) {
        this.cover(this.cmp.compare(value, 0));
    }

    public void insertProbeCode(MethodVisitor cv) {
        cv.visitInsn(89);
        cv.visitLdcInsn((Object)new Integer(this.getID()));
        cv.visitMethodInsn(184, HIT_CLASS, "hitBranch", "(II)V");
    }
}

