/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.message.component.internal;

import java.util.Optional;
import org.javacord.api.entity.emoji.CustomEmoji;
import org.javacord.api.entity.emoji.Emoji;
import org.javacord.api.entity.message.component.Button;
import org.javacord.api.entity.message.component.ButtonStyle;
import org.javacord.api.entity.message.component.ComponentType;
import org.javacord.api.entity.message.component.internal.ButtonBuilderDelegate;
import org.javacord.core.entity.emoji.UnicodeEmojiImpl;
import org.javacord.core.entity.message.component.ButtonImpl;

public class ButtonBuilderDelegateImpl
implements ButtonBuilderDelegate {
    private final ComponentType type = ComponentType.BUTTON;
    private ButtonStyle style = ButtonStyle.SECONDARY;
    private String label = null;
    private String customId = null;
    private String url = null;
    private Boolean disabled = null;
    private Emoji emoji = null;

    public ComponentType getType() {
        return this.type;
    }

    public void copy(Button button) {
        Optional customId = button.getCustomId();
        Optional url = button.getUrl();
        Optional label = button.getLabel();
        Optional emoji = button.getEmoji();
        Optional isDisabled = button.isDisabled();
        ButtonStyle style = button.getStyle();
        this.setStyle(style);
        customId.ifPresent(this::setCustomId);
        url.ifPresent(this::setUrl);
        label.ifPresent(this::setLabel);
        emoji.ifPresent(this::setEmoji);
        isDisabled.ifPresent(this::setDisabled);
    }

    public void setStyle(ButtonStyle style) {
        this.style = style;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setCustomId(String customId) {
        this.customId = customId;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDisabled(Boolean isDisabled) {
        this.disabled = isDisabled;
    }

    public Button build() {
        return new ButtonImpl(this.style, this.label, this.customId, this.url, this.disabled, this.emoji);
    }

    public void setEmoji(Emoji emoji) {
        this.emoji = emoji;
    }

    public void setEmoji(CustomEmoji emoji) {
        this.emoji = emoji;
    }

    public void setEmoji(String unicode) {
        this.emoji = UnicodeEmojiImpl.fromString(unicode);
    }

    public ButtonStyle getStyle() {
        return this.style;
    }

    public String getLabel() {
        return this.label;
    }

    public String getCustomId() {
        return this.customId;
    }

    public String getUrl() {
        return this.url;
    }

    public Boolean isDisabled() {
        return this.disabled;
    }

    public Emoji getEmoji() {
        return this.emoji;
    }
}

