/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.message.mention;

import java.util.Collection;
import java.util.HashSet;
import org.javacord.api.entity.message.mention.AllowedMentions;
import org.javacord.api.entity.message.mention.internal.AllowedMentionsBuilderDelegate;
import org.javacord.core.entity.message.mention.AllowedMentionsImpl;

public class AllowedMentionsBuilderDelegateImpl
implements AllowedMentionsBuilderDelegate {
    private final HashSet<Long> allowedUserMentions = new HashSet();
    private final HashSet<Long> allowedRoleMentions = new HashSet();
    private boolean mentionAllRoles = false;
    private boolean mentionAllUsers = false;
    private boolean mentionEveryoneAndHere = false;
    private boolean mentionRepliedUser = false;

    public void setMentionEveryoneAndHere(boolean value) {
        this.mentionEveryoneAndHere = value;
    }

    public void setMentionRoles(boolean value) {
        this.mentionAllRoles = value;
    }

    public void setMentionUsers(boolean value) {
        this.mentionAllUsers = value;
    }

    public void setMentionRepliedUser(boolean value) {
        this.mentionRepliedUser = value;
    }

    public void addUser(long userId) {
        this.allowedUserMentions.add(userId);
    }

    public void addUser(String userId) {
        this.addUser(Long.parseLong(userId));
    }

    public void addUsers(Collection<Long> userIds) {
        this.allowedUserMentions.addAll(userIds);
    }

    public void addRole(long roleId) {
        this.allowedRoleMentions.add(roleId);
    }

    public void addRole(String roleId) {
        this.addRole(Long.parseLong(roleId));
    }

    public void addRoles(Collection<Long> roleIds) {
        this.allowedRoleMentions.addAll(roleIds);
    }

    public void removeUser(long userId) {
        this.allowedUserMentions.remove(userId);
    }

    public void removeUser(String userId) {
        this.removeUser(Long.parseLong(userId));
    }

    public void removeRole(long roleId) {
        this.allowedRoleMentions.remove(roleId);
    }

    public void removeRole(String roleId) {
        this.removeRole(Long.parseLong(roleId));
    }

    public void removeUsers(Collection<Long> userIds) {
        this.allowedUserMentions.removeAll(userIds);
    }

    public void removeRoles(Collection<Long> roleIds) {
        this.allowedRoleMentions.removeAll(roleIds);
    }

    public AllowedMentions build() {
        return new AllowedMentionsImpl(this.mentionAllRoles, this.mentionAllUsers, this.mentionEveryoneAndHere, this.mentionRepliedUser, this.allowedRoleMentions, this.allowedUserMentions);
    }
}

