/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.event.message;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.channel.ServerChannel;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.emoji.Emoji;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.Reaction;
import org.javacord.api.entity.message.embed.EmbedBuilder;
import org.javacord.api.entity.server.Server;
import org.javacord.api.entity.user.User;
import org.javacord.api.event.message.MessageEvent;
import org.javacord.core.entity.emoji.UnicodeEmojiImpl;
import org.javacord.core.event.EventImpl;

public abstract class MessageEventImpl
extends EventImpl
implements MessageEvent {
    private final long messageId;
    private final TextChannel channel;

    public MessageEventImpl(Message message) {
        this(message.getApi(), message.getId(), message.getChannel());
    }

    public MessageEventImpl(DiscordApi api, long messageId, TextChannel channel) {
        super(api);
        this.messageId = messageId;
        this.channel = channel;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public TextChannel getChannel() {
        return this.channel;
    }

    public Optional<Server> getServer() {
        return this.getChannel().asServerChannel().map(ServerChannel::getServer);
    }

    public CompletableFuture<Void> deleteMessage() {
        return this.deleteMessage(null);
    }

    public CompletableFuture<Void> deleteMessage(String reason) {
        return Message.delete((DiscordApi)this.getApi(), (long)this.getChannel().getId(), (long)this.getMessageId(), (String)reason);
    }

    public CompletableFuture<Message> editMessage(String content) {
        return Message.edit((DiscordApi)this.getApi(), (long)this.getChannel().getId(), (long)this.getMessageId(), (String)content);
    }

    public CompletableFuture<Message> editMessage(List<EmbedBuilder> embeds) {
        return Message.edit((DiscordApi)this.getApi(), (long)this.getChannel().getId(), (long)this.getMessageId(), null, embeds);
    }

    public CompletableFuture<Message> editMessage(String content, List<EmbedBuilder> embeds) {
        return Message.edit((DiscordApi)this.getApi(), (long)this.getChannel().getId(), (long)this.getMessageId(), (String)content, embeds);
    }

    public CompletableFuture<Void> addReactionToMessage(String unicodeEmoji) {
        return Message.addReaction((DiscordApi)this.getApi(), (long)this.getChannel().getId(), (long)this.getMessageId(), (String)unicodeEmoji);
    }

    public CompletableFuture<Void> addReactionToMessage(Emoji emoji) {
        return Message.addReaction((DiscordApi)this.getApi(), (long)this.getChannel().getId(), (long)this.getMessageId(), (Emoji)emoji);
    }

    public CompletableFuture<Void> addReactionsToMessage(Emoji ... emojis) {
        return CompletableFuture.allOf((CompletableFuture[])Arrays.stream(emojis).map(this::addReactionToMessage).toArray(CompletableFuture[]::new));
    }

    public CompletableFuture<Void> addReactionsToMessage(String ... unicodeEmojis) {
        return this.addReactionsToMessage((Emoji[])Arrays.stream(unicodeEmojis).map(UnicodeEmojiImpl::fromString).toArray(Emoji[]::new));
    }

    public CompletableFuture<Void> removeAllReactionsFromMessage() {
        return Message.removeAllReactions((DiscordApi)this.getApi(), (long)this.getChannel().getId(), (long)this.getMessageId());
    }

    public CompletableFuture<Void> removeReactionByEmojiFromMessage(User user, Emoji emoji) {
        return Reaction.removeUser((DiscordApi)this.getApi(), (long)this.getChannel().getId(), (long)this.getMessageId(), (Emoji)emoji, (long)user.getId());
    }

    public CompletableFuture<Void> removeReactionByEmojiFromMessage(User user, String unicodeEmoji) {
        return this.removeReactionByEmojiFromMessage(user, UnicodeEmojiImpl.fromString(unicodeEmoji));
    }

    public CompletableFuture<Void> removeReactionByEmojiFromMessage(Emoji emoji) {
        return Reaction.getUsers((DiscordApi)this.getApi(), (long)this.getChannel().getId(), (long)this.getMessageId(), (Emoji)emoji).thenCompose(users -> CompletableFuture.allOf((CompletableFuture[])users.stream().map(user -> Reaction.removeUser((DiscordApi)this.getApi(), (long)this.getChannel().getId(), (long)this.getMessageId(), (Emoji)emoji, (long)user.getId())).toArray(CompletableFuture[]::new)));
    }

    public CompletableFuture<Void> removeReactionByEmojiFromMessage(String unicodeEmoji) {
        return this.removeReactionByEmojiFromMessage(UnicodeEmojiImpl.fromString(unicodeEmoji));
    }

    public CompletableFuture<Void> removeReactionsByEmojiFromMessage(User user, Emoji ... emojis) {
        return CompletableFuture.allOf((CompletableFuture[])Arrays.stream(emojis).map(emoji -> this.removeReactionByEmojiFromMessage(user, (Emoji)emoji)).toArray(CompletableFuture[]::new));
    }

    public CompletableFuture<Void> removeReactionsByEmojiFromMessage(User user, String ... unicodeEmojis) {
        return this.removeReactionsByEmojiFromMessage(user, (Emoji[])Arrays.stream(unicodeEmojis).map(UnicodeEmojiImpl::fromString).toArray(Emoji[]::new));
    }

    public CompletableFuture<Void> removeReactionsByEmojiFromMessage(Emoji ... emojis) {
        return CompletableFuture.allOf((CompletableFuture[])Arrays.stream(emojis).map(this::removeReactionByEmojiFromMessage).toArray(CompletableFuture[]::new));
    }

    public CompletableFuture<Void> removeReactionsByEmojiFromMessage(String ... unicodeEmojis) {
        return this.removeReactionsByEmojiFromMessage((Emoji[])Arrays.stream(unicodeEmojis).map(UnicodeEmojiImpl::fromString).toArray(Emoji[]::new));
    }

    public CompletableFuture<Void> removeOwnReactionByEmojiFromMessage(Emoji emoji) {
        return this.removeReactionByEmojiFromMessage(this.getApi().getYourself(), emoji);
    }

    public CompletableFuture<Void> removeOwnReactionByEmojiFromMessage(String unicodeEmoji) {
        return this.removeOwnReactionByEmojiFromMessage(UnicodeEmojiImpl.fromString(unicodeEmoji));
    }

    public CompletableFuture<Void> removeOwnReactionsByEmojiFromMessage(Emoji ... emojis) {
        return this.removeReactionsByEmojiFromMessage(this.getApi().getYourself(), emojis);
    }

    public CompletableFuture<Void> removeOwnReactionsByEmojiFromMessage(String ... unicodeEmojis) {
        return this.removeOwnReactionsByEmojiFromMessage((Emoji[])Arrays.stream(unicodeEmojis).map(UnicodeEmojiImpl::fromString).toArray(Emoji[]::new));
    }

    public CompletableFuture<Void> pinMessage() {
        return Message.pin((DiscordApi)this.getApi(), (long)this.getChannel().getId(), (long)this.getMessageId());
    }

    public CompletableFuture<Void> unpinMessage() {
        return Message.unpin((DiscordApi)this.getApi(), (long)this.getChannel().getId(), (long)this.getMessageId());
    }
}

