/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

public class MVSFileParser
extends FTPFileParser {
    private static Logger log = Logger.getLogger("MVSFileParser");
    private static final String PARSER_KEY = "MVS";
    private static final String HEADER_VOLUME = "Volume";
    private static final String HEADER_NAME = "Name";
    private static final String LINE_TYPE_ARCIVE = "ARCIVE";
    private static final String ENTRY_FILE_TYPE = "PS";
    private static final String LINE_TYPE_MIGRATED = "Migrated";
    private static final int FOLDER_HEADER_TYPE_IDX = 0;
    private static final int FOLDER_LISTING_LENGTH_NORMAL = 10;
    private static final int FOLDER_LISTING_LENGTH_ARCIVE = 8;
    private String dateFormatString;
    private String alternateFormatString;
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat dateTimeFormat;
    private boolean partitionedDataset = false;

    public boolean isValidFormat(String[] listing) {
        String[] header;
        log.debug("Checking MVS Parser for Valid Format...");
        if (listing.length > 0 && ((header = this.splitMVSLine(listing[0])).length == 10 || header.length == 8)) {
            if (header[0].equals(HEADER_VOLUME)) {
                this.partitionedDataset = false;
                log.info("Detected MVS Directory Listing Format");
                return this.isValidDirectoryFormat(listing);
            }
            if (header[0].equals(HEADER_NAME)) {
                this.partitionedDataset = true;
                log.info("Detected MVS Partitioned Dataset Listing Format");
                return this.isValidPDSFormat(listing);
            }
        }
        return false;
    }

    public FTPFile parse(String raw) throws ParseException {
        String[] aLine = this.splitMVSLine(raw);
        FTPFile rtn = null;
        rtn = this.partitionedDataset ? this.parsePDSLine(aLine, raw) : this.parseFolder(aLine, raw);
        return rtn;
    }

    public void setLocale(Locale arg0) {
        log.debug("Ignoring the set locale.");
    }

    public String toString() {
        return PARSER_KEY;
    }

    protected FTPFile parsePDSLine(String[] aLine, String raw) throws ParseException {
        FTPFile rtn = null;
        if (aLine[0].equals(HEADER_NAME)) {
            log.debug("Skipping header");
            return null;
        }
        rtn = new FTPFile(raw);
        rtn.setName(aLine[0]);
        rtn.setDir(false);
        if (aLine.length == 1) {
            return rtn;
        }
        if (this.dateTimeFormat == null && this.dateFormatString != null) {
            this.dateTimeFormat = new SimpleDateFormat(this.dateFormatString + " HH:mm");
        }
        if (this.dateTimeFormat != null) {
            rtn.setCreated(this.dateFormat.parse(aLine[2]));
            String modDateTime = aLine[3] + ' ' + aLine[4];
            rtn.setLastModified(this.dateTimeFormat.parse(modDateTime));
        }
        return rtn;
    }

    protected FTPFile parseFolder(String[] aLine, String raw) {
        if (aLine[0].equals(HEADER_VOLUME)) {
            log.debug("Skipping header");
            return null;
        }
        if (aLine[0].equals(LINE_TYPE_ARCIVE)) {
            log.debug("Skipping ARCIVE file - not supported");
            return null;
        }
        if (aLine[0].equals(LINE_TYPE_MIGRATED)) {
            log.debug("Skipping Migrated file - not supported");
            return null;
        }
        if (aLine.length != 10) {
            log.debug("Skipping invalid line: " + raw);
            return null;
        }
        if (aLine[5].charAt(0) != 'F' && aLine[5].charAt(0) != 'V') {
            log.debug("Skipping unsupported recf - needs to start with F or V");
            return null;
        }
        if (aLine[8].charAt(0) != 'P') {
            log.debug("Skipping unsupported organization - must be PS, PO, or PO-E");
            return null;
        }
        FTPFile rtn = new FTPFile(raw);
        rtn.setName(aLine[9]);
        rtn.setCreated(new Date());
        rtn.setLastModified(new Date());
        if (aLine[8].equals(ENTRY_FILE_TYPE)) {
            log.debug("Found a file (PS) - " + aLine[9]);
            rtn.setDir(false);
            long l = -1L;
            try {
                l = Long.parseLong(aLine[4]);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            rtn.setSize(l);
        } else {
            log.debug("Found a folder (PO/PO-E) - " + aLine[9]);
            rtn.setDir(true);
        }
        return rtn;
    }

    protected String[] splitMVSLine(String raw) {
        if (raw == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(raw);
        String[] rtn = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            rtn[i] = nextToken.trim();
            ++i;
        }
        return rtn;
    }

    protected boolean isValidDirectoryFormat(String[] listing) {
        for (int i = 1; i < listing.length; ++i) {
            String[] aLine = this.splitMVSLine(listing[i]);
            if (aLine.length == 2 && aLine[0].equals(LINE_TYPE_MIGRATED)) {
                log.debug("Detected a migrated entry");
                continue;
            }
            if (aLine.length != 10 && !aLine[0].equals(LINE_TYPE_ARCIVE)) {
                log.debug("Invalid Directory Line: " + listing[i]);
                continue;
            }
            if (this.dateFormatString != null) {
                if (this.checkDateFormat(aLine[2])) continue;
                return false;
            }
            if (aLine.length != 10) continue;
            this.guessDateFormat(aLine[2]);
        }
        return true;
    }

    protected boolean isValidPDSFormat(String[] listing) {
        for (int i = 1; i < listing.length; ++i) {
            String[] aLine = this.splitMVSLine(listing[i]);
            if (aLine.length == 1) continue;
            if (aLine.length != 9) {
                log.error("Invalid PDS Line: " + listing[i]);
                return false;
            }
            if (this.dateFormatString != null) {
                if (this.checkDateFormat(aLine[3])) continue;
                return false;
            }
            this.guessDateFormat(aLine[2]);
        }
        return true;
    }

    protected boolean checkDateFormat(String dateStr) {
        try {
            this.dateFormat.parse(dateStr);
        }
        catch (ParseException ex) {
            log.debug("Date parse exception - probably swapped day/month");
            if (this.alternateFormatString != null) {
                log.debug("Choosing alternate format");
                this.dateFormatString = this.alternateFormatString;
                this.dateFormat = new SimpleDateFormat(this.dateFormatString);
                this.alternateFormatString = null;
                try {
                    this.dateFormat.parse(dateStr);
                }
                catch (ParseException ex2) {
                    return false;
                }
            }
            log.error("FAIL - no alternate to fall back on. Date cannot be parsed - " + dateStr);
            return false;
        }
        return true;
    }

    protected void guessDateFormat(String dateStr) {
        log.debug("Guessing the date format...");
        String[] dateSplit = dateStr.split("/");
        String yrFmt = null;
        int yrPos = -1;
        int dayPos = -1;
        for (int i = 0; i < dateSplit.length; ++i) {
            int aDigit = Integer.parseInt(dateSplit[i]);
            if (dateSplit[i].length() == 4) {
                yrFmt = "yyyy";
                yrPos = i;
                continue;
            }
            if (aDigit > 31) {
                yrFmt = "yy";
                yrPos = i;
                continue;
            }
            if (aDigit <= 12) continue;
            dayPos = i;
        }
        if (yrFmt != null) {
            StringBuffer fmt = new StringBuffer();
            if (dayPos >= 0) {
                String[] tmp = new String[3];
                tmp[yrPos] = yrFmt;
                tmp[dayPos] = "dd";
                for (int i = 0; i < tmp.length; ++i) {
                    fmt.append(i > 0 ? "/" : "");
                    fmt.append(tmp[i] == null ? "MM" : tmp[i]);
                }
                log.debug("Easy one - found obvious year, and obvious day");
            } else {
                StringBuffer altFmt = new StringBuffer();
                if (yrPos == 0) {
                    fmt.append(yrFmt).append("/MM/dd");
                    altFmt.append(yrFmt).append("/dd/MM");
                } else {
                    fmt.append("MM/dd/").append(yrFmt);
                    altFmt.append("dd/MM/").append(yrFmt);
                }
                this.alternateFormatString = altFmt.toString();
                log.debug("Ambiguous one - found obvious year, but day/month could be wrong so created alternate");
            }
            this.dateFormatString = fmt.toString();
            this.dateFormat = new SimpleDateFormat(this.dateFormatString);
            log.debug("Decided on " + this.dateFormatString);
            try {
                this.dateFormat.parse(dateStr);
            }
            catch (ParseException ex) {
                log.debug("Parse failed - Invalid Date: " + dateStr);
            }
        } else {
            log.debug("Could not figure out year from this date format");
            return;
        }
    }

    public boolean isPartitionedDataset() {
        return this.partitionedDataset;
    }

    public String getDateFormatString() {
        return this.dateFormatString;
    }

    public void setDateFormatString(String value) {
        this.dateFormatString = value;
    }
}

