/*
 * Copyright (c) 2001 Matthew Feldt. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided the copyright notice above is
 * retained.
 *
 * THIS SOFTWARE IS PROVIDED ''AS IS'' AND WITHOUT ANY EXPRESSED OR
 * IMPLIED WARRANTIES.
 */

/**
 * AltimeterTest.java
 *
 * @author Matthew Feldt <developer@feldt.com>
 * @version 0.1, 01/25/2005
 */
package com.feldt.metar;

import junit.framework.TestCase;

public class AltimeterTest extends TestCase {

	public void testParseAltimeter() {
		Altimeter altimeter = Altimeter.parseAltimeter(null);
		assertNull(altimeter);
		
		altimeter = Altimeter.parseAltimeter("");
		assertNull(altimeter);
		
		altimeter = Altimeter.parseAltimeter("A12");
		assertNull(altimeter);
		
		altimeter = Altimeter.parseAltimeter("X1234");
		assertNull(altimeter);
		
		altimeter = Altimeter.parseAltimeter("AX234");
		assertNull(altimeter);
		
		altimeter = Altimeter.parseAltimeter("A1234");
		assertEquals(new Float(12.34), altimeter.getAltimeter());
		
		altimeter = Altimeter.parseAltimeter("Q1234");
		assertEquals(new Float(36.438477), altimeter.getAltimeter());
	}
	
	public void testToString() {
		Altimeter altimeter = Altimeter.parseAltimeter("A1234");
		assertEquals("A1234", altimeter.toString());
	}
	
	public void testGetFormattedAltimeter() {
		Altimeter altimeter = Altimeter.parseAltimeter("A1234");
		assertEquals("12.34 in. Hg (417 hPa)", altimeter.getFormattedAltimeter());
	}
}
