/*
 * Copyright (c) 2001 Matthew Feldt. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided the copyright notice above is
 * retained.
 *
 * THIS SOFTWARE IS PROVIDED ''AS IS'' AND WITHOUT ANY EXPRESSED OR
 * IMPLIED WARRANTIES.
 */

/**
 * ConditionTest.java
 *
 * @author Matthew Feldt <developer@feldt.com>
 * @version 0.1, 01/21/2005
 */
package com.feldt.metar;

import junit.framework.TestCase;


public class ConditionTest extends TestCase {

	public void testIsACondition() {
//		// too short, too long, etc...
//		assertFalse(Condition.isACondition(null));
//		assertFalse(Condition.isACondition(""));
//		assertFalse(Condition.isACondition("XXXXXXXXX"));
//		
//		// fail cases
//		assertFalse(Condition.isACondition("+F"));
//		assertFalse(Condition.isACondition("XX"));
//		assertFalse(Condition.isACondition("RAX"));
//		
//		// pass cases
//		assertTrue(Condition.isACondition("-DZ"));
//		assertTrue(Condition.isACondition("+RA"));
//		assertTrue(Condition.isACondition("VCSN"));
//		assertTrue(Condition.isACondition("VCBCPL"));
//		assertTrue(Condition.isACondition("+GR+FC"));
//		assertTrue(Condition.isACondition("+FC"));
		assertTrue(Condition.isACondition("BLSN"));
	}
	
	public void testParseCondition() {
		Condition condition = Condition.parseCondition(null);
		assertNull(condition);
		
		condition = Condition.parseCondition("");
		assertNull(condition);
		
		condition = Condition.parseCondition("X");
		assertNull(condition);
		
		condition = Condition.parseCondition("XXXXXXXXX"); // too many chars
		assertNull(condition);
		
		condition = Condition.parseCondition("RNX"); // trailing evil
		assertNull(condition);
		
		condition = Condition.parseCondition("-DZ");
		assertTrue(condition.hasCondition("-"));
		assertTrue(condition.hasCondition("DZ"));
		
		condition = null;
		condition = Condition.parseCondition("+FC");
		assertTrue(condition.hasCondition("+FC"));
	}
	
	public void testHasCondition() {
		Condition condition = Condition.parseCondition("+BLSN");
		assertFalse(condition.hasCondition(null)); // input parm null
		assertFalse(condition.hasCondition("RN")); // no match
		assertTrue(condition.hasCondition("SN")); // matches 
		
	}
}
