/*
 * Copyright (c) 2001 Matthew Feldt. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided the copyright notice above is
 * retained.
 *
 * THIS SOFTWARE IS PROVIDED ''AS IS'' AND WITHOUT ANY EXPRESSED OR
 * IMPLIED WARRANTIES.
 */

/**
 * VisibilityTest.java
 *
 * @author Matthew Feldt <developer@feldt.com>
 * @version 0.7, 01/25/2005
 */
package com.feldt.metar;

import junit.framework.TestCase;


public class VisibilityTest extends TestCase {

	public void testisAVisibility() {
		// not enough characters or incorrect terminating characters
		assertFalse(Visibility.isAVisibility(null));
		assertFalse(Visibility.isAVisibility("00"));
		assertFalse(Visibility.isAVisibility("0XM"));
		assertFalse(Visibility.isAVisibility("0SX"));
		assertFalse(Visibility.isAVisibility("XSM"));
		assertFalse(Visibility.isAVisibility("MSM"));
		
		// evil combinations of '/' and ' '
		assertFalse(Visibility.isAVisibility("0  SM"));
		assertFalse(Visibility.isAVisibility("1/4/3SM"));
		assertFalse(Visibility.isAVisibility("1/SM"));
		
		// successful cases
		assertTrue(Visibility.isAVisibility("1/4SM"));
		assertTrue(Visibility.isAVisibility("0SM"));
		assertTrue(Visibility.isAVisibility("M0SM"));
	}
	
	public void testVisibility() {
		Visibility visibility = Visibility.parseVisibility("M1/4SM");
		assertTrue(visibility.isLessThan());
		assertEquals("1/4", visibility.getVisibility());
		
		visibility = Visibility.parseVisibility("20SM");
		assertFalse(visibility.isLessThan());
		assertEquals("20", visibility.getVisibility());
	}
}