CREATE TABLE COOLER_THREADS (
 ID						INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
 SUBJECT				VARCHAR(96) CHARACTER SET utf8mb4 NOT NULL,
 CHANNEL				VARCHAR(64) NOT NULL,
 IMAGE_ID				INTEGER UNSIGNED,
 STICKY					DATETIME,
 HIDDEN					BOOLEAN NOT NULL DEFAULT FALSE,
 LOCKED					BOOLEAN NOT NULL DEFAULT FALSE,
 STICKY_CHANNEL			BOOLEAN NOT NULL DEFAULT FALSE,
 REPORTS				TINYINT UNSIGNED DEFAULT 0,
 VIEWS					INTEGER UNSIGNED,
 POSTS					INTEGER UNSIGNED,
 AUTHOR					INTEGER UNSIGNED NOT NULL,
 LASTUPDATE				DATETIME NOT NULL,
 LASTPOSTER				INTEGER UNSIGNED NOT NULL,
 SORTDATE				DATETIME NOT NULL,
 PRIMARY KEY (ID),
 FOREIGN KEY (CHANNEL) REFERENCES COOLER_CHANNELS(CHANNEL) ON UPDATE CASCADE,
 FOREIGN KEY (AUTHOR) REFERENCES USERDATA(ID),
 FOREIGN KEY (LASTPOSTER) REFERENCES USERDATA(ID)
);

CREATE INDEX CT_SORT_IDX ON COOLER_THREADS(SORTDATE DESC);
CREATE INDEX CT_UPD_IDX ON COOLER_THREADS(LASTUPDATE DESC);
CREATE INDEX CT_IMG_IDX ON COOLER_THREADS(IMAGE_ID);
  