CREATE TABLE HELPDESK (
 ID						INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
 AUTHOR					INTEGER UNSIGNED NOT NULL,
 ASSIGNEDTO				INTEGER UNSIGNED NOT NULL,
 CREATED_ON				DATETIME NOT NULL,
 RESOLVED_ON			DATETIME,
 STATUS					TINYINT UNSIGNED,
 ISPUBLIC				BOOLEAN NOT NULL DEFAULT FALSE,
 ISFAQ					BOOLEAN NOT NULL DEFAULT FALSE,
 SUBJECT				VARCHAR(128) CHARACTER SET utf8mb4 NOT NULL,
 BODY					TEXT CHARACTER SET utf8mb4 NOT NULL,
 PRIMARY KEY (ID),
 FOREIGN KEY (AUTHOR) REFERENCES common.USERDATA(ID),
 FOREIGN KEY (ASSIGNEDTO) REFERENCES common.USERDATA(ID)
) ROW_FORMAT=Dynamic;

CREATE INDEX HELPDESK_ST_IDX ON HELPDESK(STATUS);
