CREATE TABLE RESOURCES (
 ID						INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
 URL					VARCHAR(224) NOT NULL,
 TITLE					VARCHAR(128),
 REMARKS				TEXT CHARACTER SET utf8mb4 NOT NULL,
 CREATEDON				DATE NOT NULL,
 CATEGORY				VARCHAR(32) NOT NULL,
 AUTHOR					INTEGER UNSIGNED NOT NULL,
 UPDATEDBY				INTEGER UNSIGNED NOT NULL,
 HITCOUNT				INTEGER UNSIGNED DEFAULT 0,
 ISPUBLIC				BOOLEAN NOT NULL DEFAULT FALSE,
 IGNORE_CERTS           BOOLEAN NOT NULL DEFAULT FALSE,
 DOMAIN					VARCHAR(128) NOT NULL,
 PRIMARY KEY (ID),
 FOREIGN KEY (AUTHOR) REFERENCES common.USERDATA(ID) ON UPDATE CASCADE,
 FOREIGN KEY (UPDATEDBY) REFERENCES common.USERDATA(ID) ON UPDATE CASCADE
) ROW_FORMAT=Dynamic;

CREATE UNIQUE INDEX RS_URL_IDX ON RESOURCES(URL);
CREATE INDEX RSRC_CD_IDX ON RESOURCES(CREATEDON);
