CREATE TABLE AIRSPACE (
 ID                 VARCHAR(24) NOT NULL,
 NAME               VARCHAR(48) NOT NULL,
 COUNTRY            CHAR(2) NOT NULL,
 TYPE               TINYINT UNSIGNED NOT NULL,
 EXCLUSION          BOOLEAN NOT NULL DEFAULT FALSE,
 MIN_ALT            INTEGER UNSIGNED NOT NULL,
 MAX_ALT            INTEGER UNSIGNED NOT NULL,
 DATA               POLYGON NOT NULL SRID 4326,
 LATITUDE           DECIMAL(10, 6) NOT NULL,
 LONGITUDE          DECIMAL(10, 6) NOT NULL,
 PRIMARY KEY (ID, LATITUDE, LONGITUDE)
) ROW_FORMAT=Dynamic;

CREATE INDEX AIRSPACE_CT_IDX ON AIRSPACE(COUNTRY);
CREATE INDEX AIRSPACE_TYPE_IDX ON AIRSPACE(TYPE);
CREATE INDEX AIRSPACE_ALT_IDX ON AIRSPACE(MIN_ALT, MAX_ALT);
CREATE SPATIAL INDEX AIRSPACE_GEO_IDX ON AIRSPACE(DATA);
