CREATE TABLE ACARS_PIREPS (
 ID					INTEGER UNSIGNED NOT NULL,
 ACARS_ID			INTEGER UNSIGNED NOT NULL,
 START_TIME			DATETIME NOT NULL,
 START_LAT          DECIMAL(7,4) NOT NULL DEFAULT 0,
 START_LNG          DECIMAL(7,4) NOT NULL DEFAULT 0,
 TAXI_TIME			DATETIME NOT NULL,
 TAXI_WEIGHT		INTEGER NOT NULL,
 TAXI_FUEL			INTEGER NOT NULL,
 TAKEOFF_TIME		DATETIME NOT NULL,
 TAKEOFF_DISTANCE	SMALLINT,
 TAKEOFF_SPEED		SMALLINT NOT NULL,
 TAKEOFF_N1			DECIMAL(4,1) NOT NULL,
 TAKEOFF_HDG		SMALLINT NOT NULL DEFAULT -1,
 TAKEOFF_LAT		DECIMAL (7,4) NOT NULL DEFAULT 0,
 TAKEOFF_LNG		DECIMAL (7,4) NOT NULL DEFAULT 0,
 TAKEOFF_ALT		SMALLINT NOT NULL DEFAULT 0,
 TAKEOFF_WEIGHT		INTEGER NOT NULL,
 TAKEOFF_FUEL		INTEGER NOT NULL,
 LANDING_TIME		DATETIME NOT NULL,
 LANDING_DISTANCE	SMALLINT,
 LANDING_SPEED		SMALLINT NOT NULL,
 LANDING_VSPEED		SMALLINT,
 LANDING_G			DECIMAL(5,3) NOT NULL DEFAULT 0,
 LANDING_N1			DECIMAL(4,1) NOT NULL,
 LANDING_HDG		SMALLINT NOT NULL DEFAULT -1,
 LANDING_LAT		DECIMAL (7,4) NOT NULL DEFAULT 0,
 LANDING_LNG		DECIMAL (7,4) NOT NULL DEFAULT 0,
 LANDING_ALT		SMALLINT NOT NULL DEFAULT 0,
 LANDING_WEIGHT		INTEGER NOT NULL,
 LANDING_FUEL		INTEGER,
 LANDING_CAT		SMALLINT UNSIGNED NOT NULL DEFAULT 0,
 LANDING_SCORE      SMALLINT NOT NULL DEFAULT -1,
 END_TIME			DATETIME NOT NULL,
 GATE_WEIGHT		INTEGER NOT NULL,
 GATE_FUEL			INTEGER,
 GATE_LAT           DECIMAL(7,4) NOT NULL DEFAULT 0, 
 GATE_LNG           DECIMAL(7,4) NOT NULL DEFAULT 0,
 TOTAL_FUEL			INTEGER NOT NULL DEFAULT 0,
 PAX_WEIGHT         INTEGER UNSIGNED NOT NULL DEFAULT 0,
 CARGO_WEIGHT       INTEGER UNSIGNED NOT NULL DEFAULT 0,
 TIME_0X			INTEGER UNSIGNED DEFAULT 0,
 TIME_1X			INTEGER UNSIGNED DEFAULT 0,
 TIME_2X			INTEGER UNSIGNED DEFAULT 0,
 TIME_4X			INTEGER UNSIGNED DEFAULT 0,
 TIME_BOARD         INTEGER UNSIGNED NOT NULL DEFAULT 0,
 TIME_DEBOARD       INTEGER UNSIGNED NOT NULL DEFAULT 0,
 TIME_ONLINE        INTEGER UNSIGNED NOT NULL DEFAULT 0,
 FDE				VARCHAR(64),
 CODE				VARCHAR(24),
 SDK                VARCHAR(12),
 TAILCODE           VARCHAR(16),
 CAPABILITIES		BIGINT UNSIGNED NOT NULL DEFAULT 0,
 RESTORE_COUNT      SMALLINT UNSIGNED NOT NULL DEFAULT 0,
 RELOAD				BOOLEAN NOT NULL DEFAULT FALSE,
 FRAMERATE			SMALLINT UNSIGNED NOT NULL DEFAULT 0,
 CLIENT_BUILD		SMALLINT UNSIGNED NOT NULL DEFAULT 0,
 BETA_BUILD			SMALLINT UNSIGNED NOT NULL DEFAULT 0,
 PRIMARY KEY (ID),
 FOREIGN KEY (ID) REFERENCES PIREPS(ID) ON DELETE CASCADE
);

CREATE INDEX APR_AID_IDX ON ACARS_PIREPS(ACARS_ID);
CREATE INDEX APR_SDK_IDX ON ACARS_PIREPS(SDK);