CREATE TABLE ISSUES (
 ID						INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
 AUTHOR					INTEGER UNSIGNED NOT NULL,
 ASSIGNEDTO				INTEGER UNSIGNED NOT NULL,
 CREATED				DATETIME NOT NULL,
 RESOLVED				DATETIME,
 SUBJECT				VARCHAR(128) CHARACTER SET utf8mb4 NOT NULL,
 DESCRIPTION			TEXT CHARACTER SET utf8mb4 NOT NULL,
 AREA					SMALLINT,
 PRIORITY				SMALLINT,
 STATUS					SMALLINT,
 TYPE					SMALLINT,
 MAJOR					SMALLINT,
 MINOR					SMALLINT,
 SECURITY				SMALLINT UNSIGNED NOT NULL DEFAULT 0,
 PRIMARY KEY (ID),
 FOREIGN KEY (AUTHOR) REFERENCES USERDATA(ID),
 FOREIGN KEY (ASSIGNEDTO) REFERENCES USERDATA(ID)
);

CREATE INDEX ISSUE_ST_IDX ON ISSUES(STATUS);
CREATE INDEX ISSUE_PR_IDX ON ISSUES(PRIORITY);
