CREATE TABLE EXAMS (
 ID                 INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
 NAME               VARCHAR(40) NOT NULL,
 PILOT_ID           INTEGER UNSIGNED NOT NULL,
 STATUS             SMALLINT,
 CREATED_ON         DATETIME NOT NULL,
 EXPIRY_TIME        DATETIME NOT NULL,
 SUBMITTED_ON       DATETIME,
 GRADED_ON          DATETIME,
 GRADED_BY          INTEGER UNSIGNED,
 PASS               BOOLEAN NOT NULL DEFAULT FALSE,
 ISEMPTY			BOOLEAN DEFAULT FALSE,
 AUTOSCORE			BOOLEAN DEFAULT FALSE,
 COMMENTS			TEXT CHARACTER SET utf8mb4,
 PRIMARY KEY (ID),
 FOREIGN KEY (NAME) REFERENCES EXAMINFO(NAME) ON UPDATE CASCADE,
 FOREIGN KEY (PILOT_ID) REFERENCES common.USERDATA(ID) ON DELETE CASCADE
);

CREATE INDEX EX_DT_IDX ON EXAMS(CREATED_ON);